/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.environmental.common.entity.animal.MuddyPig;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MuddyPigDecorationLayer<T extends Pig, M extends QuadrupedModel<T>>
extends RenderLayer<T, M> {
    private final BlockRenderDispatcher blockRenderer;

    public MuddyPigDecorationLayer(RenderLayerParent<T, M> parent, BlockRenderDispatcher renderer) {
        super(parent);
        this.blockRenderer = renderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int p_117258_, T pig, float p_117260_, float p_117261_, float p_117262_, float p_117263_, float p_117264_, float p_117265_) {
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = minecraft.shouldEntityAppearGlowing(pig) && pig.isInvisible();
        Optional<Item> decoration = MuddyPig.getDecoration(pig);
        if (MuddyPig.enabled() && decoration.isPresent() && (!pig.isInvisible() || flag)) {
            BlockState state = ((BlockItem)decoration.get()).getBlock().defaultBlockState();
            int i = LivingEntityRenderer.getOverlayCoords(pig, (float)0.0f);
            BakedModel bakedmodel = this.blockRenderer.getBlockModel(state);
            poseStack.pushPose();
            if (pig.isBaby()) {
                poseStack.translate(0.0, 0.25, 0.25);
            }
            ((QuadrupedModel)this.getParentModel()).head.translateAndRotate(poseStack);
            poseStack.translate(0.1, -0.5625, (double)-0.35f);
            poseStack.scale(-0.625f, -0.625f, 0.625f);
            poseStack.translate(-0.5, -0.5, -0.5);
            this.renderDecoration(poseStack, bufferSource, p_117258_, flag, state, i, bakedmodel);
            poseStack.popPose();
        }
    }

    private void renderDecoration(PoseStack p_234853_, MultiBufferSource p_234854_, int p_234855_, boolean p_234856_, BlockState p_234857_, int p_234858_, BakedModel p_234859_) {
        if (p_234856_) {
            this.blockRenderer.getModelRenderer().renderModel(p_234853_.last(), p_234854_.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), p_234857_, p_234859_, 0.0f, 0.0f, 0.0f, p_234855_, p_234858_);
        } else {
            this.blockRenderer.renderSingleBlock(p_234857_, p_234853_, p_234854_, p_234855_, p_234858_);
        }
    }
}

