/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.client.model.ZonkeyModel;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zonkey;
import com.teamabnormals.environmental.core.Environmental;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ZonkeyStripesRenderLayer
extends RenderLayer<Zonkey, ZonkeyModel<Zonkey>> {
    private static final ResourceLocation STRIPES_LOCATION = Environmental.location("textures/entity/zebroid/zonkey_overlay.png");

    public ZonkeyStripesRenderLayer(RenderLayerParent<Zonkey, ZonkeyModel<Zonkey>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Zonkey zonkey, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!zonkey.isInvisible()) {
            VertexConsumer builder = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)STRIPES_LOCATION));
            float f = Mth.clamp((float)((float)zonkey.getStripeOpacity() / 100.0f), (float)0.0f, (float)1.0f);
            ((ZonkeyModel)this.getParentModel()).renderToBuffer(poseStack, builder, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)zonkey, (float)0.0f), FastColor.ARGB32.colorFromFloat((float)f, (float)1.0f, (float)1.0f, (float)1.0f));
        }
    }
}

