/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.client.model.ZorseModel;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class ZorseArmorLayer
extends RenderLayer<Zorse, ZorseModel<Zorse>> {
    private final ZorseModel<Zorse> model;

    public ZorseArmorLayer(RenderLayerParent<Zorse, ZorseModel<Zorse>> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.model = new ZorseModel(modelSet.bakeLayer(EnvironmentalModelLayers.ZORSE_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Zorse zorse, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        AnimalArmorItem animalArmor;
        ItemStack stack = zorse.getBodyArmorItem();
        Item item = stack.getItem();
        if (item instanceof AnimalArmorItem && (animalArmor = (AnimalArmorItem)item).getBodyType() == AnimalArmorItem.BodyType.EQUESTRIAN) {
            ((ZorseModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.model);
            this.model.prepareMobModel(zorse, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim(zorse, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int i = -1;
            if (stack.is(ItemTags.DYEABLE)) {
                i = FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)-6265536));
            }
            ZorseArmorLayer.setColorRuneTarget(stack);
            VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)animalArmor.getTexture()), (boolean)false, (boolean)stack.hasFoil());
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, i);
        }
    }

    private static void setColorRuneTarget(ItemStack stack) {
        if (ModList.get().isLoaded("quark")) {
            // empty if block
        }
    }
}

