/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.WisteriaLeafColorBlock;
import com.teamabnormals.environmental.common.levelgen.util.WisteriaColor;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class ColoredWisteriaLeavesBlock
extends LeavesBlock
implements WisteriaLeafColorBlock {
    private static final Map<WisteriaColor, Supplier<Block>> LEAVES = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(WisteriaColor.PINK, EnvironmentalBlocks.PINK_WISTERIA_LEAVES);
        map.put(WisteriaColor.BLUE, EnvironmentalBlocks.BLUE_WISTERIA_LEAVES);
        map.put(WisteriaColor.PURPLE, EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES);
        map.put(WisteriaColor.WHITE, EnvironmentalBlocks.WHITE_WISTERIA_LEAVES);
    });
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    private final WisteriaColor color;

    public ColoredWisteriaLeavesBlock(BlockBehaviour.Properties properties, WisteriaColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (direction == Direction.DOWN && state.getValue(HALF) == Half.TOP) {
            WisteriaLeafColorBlock leaves;
            Block block = offsetState.getBlock();
            if (block instanceof WisteriaLeafColorBlock && (leaves = (WisteriaLeafColorBlock)block).causesBlendTexture(offsetState)) {
                return (BlockState)((BlockState)((BlockState)((BlockState)ColoredWisteriaLeavesBlock.getLeavesFromColor(leaves.getColor()).defaultBlockState().setValue((Property)DISTANCE, (Comparable)((Integer)state.getValue((Property)DISTANCE)))).setValue((Property)PERSISTENT, (Comparable)((Boolean)state.getValue((Property)PERSISTENT)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)))).setValue(HALF, (Comparable)Half.TOP);
            }
            return (BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get()).defaultBlockState().setValue((Property)DISTANCE, (Comparable)((Integer)state.getValue((Property)DISTANCE)))).setValue((Property)PERSISTENT, (Comparable)((Boolean)state.getValue((Property)PERSISTENT)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        }
        return super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return state.getValue(HALF) == Half.TOP ? new ItemStack((ItemLike)EnvironmentalBlocks.WISTERIA_LEAVES.get()) : super.getCloneItemStack(level, pos, state);
    }

    @Override
    public WisteriaColor getColor() {
        return this.color;
    }

    @Override
    public boolean causesBlendTexture(BlockState state) {
        return state.getValue(HALF) == Half.BOTTOM;
    }

    public static ColoredWisteriaLeavesBlock getLeavesFromColor(WisteriaColor color) {
        return (ColoredWisteriaLeavesBlock)LEAVES.get((Object)color).get();
    }
}

