/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import com.teamabnormals.environmental.common.block.RedstoneDwarfSpruceBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;

public abstract class DwarfSpruceBlock
extends BushBlock
implements BonemealableBlock {
    protected final Supplier<Item> torch;

    public DwarfSpruceBlock(BlockBehaviour.Properties properties, Supplier<Item> torch) {
        super(properties);
        this.torch = torch;
        if (torch != null) {
            this.getTorchSpruces().put(torch, (Block)this);
        }
    }

    public abstract Item getTorch();

    public abstract BlockState getWithoutTorchesState(BlockState var1);

    abstract Map<Supplier<? extends Item>, Block> getTorchSpruces();

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowpos = pos.below();
        BlockState belowstate = level.getBlockState(belowpos);
        return belowstate.getBlock() instanceof DwarfSpruceBlock || DwarfSpruceBlock.canSupportCenter((LevelReader)level, (BlockPos)belowpos, (Direction)Direction.UP) || belowstate.getBlock() instanceof LeavesBlock;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Block torchspruce;
        Item item = stack.getItem();
        Item torch = this.getTorch();
        if (stack.canPerformAction(ItemAbilities.SHEARS_HARVEST) && torch != null) {
            DwarfSpruceBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)torch));
            level.setBlockAndUpdate(pos, this.getWithoutTorchesState(state));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.SNOW_GOLEM_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (item != Items.AIR && torch == null && (torchspruce = (Block)this.getTorchSpruces().getOrDefault(this.getTorchSpruces().keySet().stream().filter(key -> item == key.get()).findFirst().orElse(null), null)) != null) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            BlockState blockstate = torchspruce.withPropertiesOf(state);
            if (item == Items.REDSTONE_TORCH) {
                blockstate = RedstoneDwarfSpruceBlock.setLitPoweredState(blockstate, level, pos);
            }
            level.setBlockAndUpdate(pos, blockstate);
            level.playSound(null, pos, SoundEvents.AZALEA_LEAVES_PLACE, SoundSource.BLOCKS, 0.4f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Item torch = this.getTorch();
        if (torch != null) {
            drops.add(new ItemStack((ItemLike)torch));
        }
        return drops;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)EnvironmentalBlocks.DWARF_SPRUCE.get());
    }

    protected static BlockPos getHeadPos(BlockGetter level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            mutable.move(Direction.UP);
            if (!(level.getBlockState((BlockPos)mutable).getBlock() instanceof DwarfSpruceHeadBlock)) continue;
            return mutable.immutable();
        } while (level.getBlockState((BlockPos)mutable).getBlock() instanceof DwarfSprucePlantBlock);
        return null;
    }

    protected static boolean isValidAboveBlock(BlockState state) {
        return state.getBlock() instanceof DwarfSpruceHeadBlock && (Boolean)state.getValue((Property)DwarfSpruceHeadBlock.TOP) != false || state.getBlock() instanceof DwarfSprucePlantBlock && (Boolean)state.getValue((Property)DwarfSprucePlantBlock.BOTTOM) == false;
    }
}

