/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.DwarfSpruceBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;

public class DwarfSpruceHeadBlock
extends DwarfSpruceBlock {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty STAR = BooleanProperty.create((String)"star");
    private static final Map<Supplier<? extends Item>, Block> TORCH_SPRUCES = Maps.newHashMap();
    protected DwarfSprucePlantBlock bodyBlock;

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties) {
        this(properties, (Supplier<Item>)null);
    }

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties, ResourceLocation torch) {
        this(properties, () -> (Item)BuiltInRegistries.ITEM.get(torch));
    }

    public DwarfSpruceHeadBlock(BlockBehaviour.Properties properties, Supplier<Item> torch) {
        super(properties, torch);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)STAR, (Comparable)Boolean.valueOf(false)));
    }

    public void setBodyBlock(DwarfSprucePlantBlock block) {
        this.bodyBlock = block;
    }

    @Override
    public Item getTorch() {
        return this.torch == null || this.torch.get() == Items.AIR ? null : (Item)this.torch.get();
    }

    @Override
    public Map<Supplier<? extends Item>, Block> getTorchSpruces() {
        return TORCH_SPRUCES;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        int light = state.getLightEmission();
        return (Boolean)state.getValue((Property)STAR) != false && light < 10 ? 10 : light;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState belowstate = level.getBlockState(pos.below());
        boolean flag = belowstate.getBlock() instanceof DwarfSpruceHeadBlock;
        if (DwarfSpruceHeadBlock.isValidAboveBlock(level.getBlockState(pos.above()))) {
            return (BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()).defaultBlockState().setValue((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf(!flag));
        }
        if (flag) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)STAR, (Comparable)((Boolean)belowstate.getValue((Property)STAR)));
        }
        return this.defaultBlockState();
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return direction == Direction.UP && DwarfSpruceHeadBlock.isValidAboveBlock(offsetState) ? this.getBodyState(state) : state;
    }

    protected BlockState getBodyState(BlockState originalState) {
        return (BlockState)this.bodyBlock.defaultBlockState().setValue((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf((Boolean)originalState.getValue((Property)TOP) == false));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Item item = stack.getItem();
        if (stack.canPerformAction(ItemAbilities.SHEARS_HARVEST) && ((Boolean)state.getValue((Property)STAR)).booleanValue()) {
            DwarfSpruceHeadBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.NETHER_STAR));
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAR, (Comparable)Boolean.valueOf(false)));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.SNOW_GOLEM_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!((Boolean)state.getValue((Property)STAR)).booleanValue() && item == Items.NETHER_STAR) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAR, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, SoundEvents.AZALEA_LEAVES_PLACE, SoundSource.BLOCKS, 0.4f, 1.0f);
            level.playSound(null, pos, SoundEvents.AMETHYST_CLUSTER_PLACE, SoundSource.BLOCKS, 0.8f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    @Override
    public BlockState getWithoutTorchesState(BlockState state) {
        return (BlockState)((BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).defaultBlockState().setValue((Property)TOP, (Comparable)((Boolean)state.getValue((Property)TOP)))).setValue((Property)STAR, (Comparable)((Boolean)state.getValue((Property)STAR)));
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)STAR, (Comparable)((Boolean)state.getValue((Property)STAR))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP, STAR});
    }
}

