/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.Lists;
import com.teamabnormals.environmental.common.block.WallHibiscusBlock;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HibiscusLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public HibiscusLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)));
    }

    public boolean isValidBonemealTarget(LevelReader blockGetter, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!blockGetter.getBlockState(pos.relative(direction)).isAir()) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        ArrayList directions = Lists.newArrayList();
        for (Direction direction : Direction.values()) {
            if (!level.getBlockState(pos.relative(direction)).isAir()) continue;
            directions.add(direction);
        }
        if (!directions.isEmpty()) {
            Direction direction = (Direction)directions.get(random.nextInt(directions.size()));
            ((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(EnvironmentalBlockTags.WALL_HIBISCUSES).get()).getRandomElement(random).ifPresent(block -> level.setBlockAndUpdate(pos.relative(direction), WallHibiscusBlock.setPropertiesForDirection(((Block)block.value()).defaultBlockState(), direction, random)));
        }
    }
}

