/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.environmental.common.block.AbstractHibiscusBlock;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallHibiscusBlock
extends AbstractHibiscusBlock {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0), (Object)Direction.SOUTH, (Object)Block.box((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.box((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0), (Object)Direction.EAST, (Object)Block.box((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (Object)Direction.UP, (Object)Block.box((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (Object)Direction.DOWN, (Object)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));

    public WallHibiscusBlock(Holder<MobEffect> stewEffect, int stewEffectDuration, BlockBehaviour.Properties properties) {
        super(stewEffect, stewEffectDuration, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.WALL));
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return AABBS.get(WallHibiscusBlock.getConnectedDirection(state).getOpposite()).move(vec3.x, vec3.y, vec3.z);
    }

    @Override
    protected Block getWallHibiscus() {
        return this;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.LEAVES);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.canAttach(level, pos, WallHibiscusBlock.getConnectedDirection(state).getOpposite());
    }

    public boolean canAttach(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos offsetPos = pos.relative(direction);
        BlockState offsetState = level.getBlockState(offsetPos);
        return offsetState.isFaceSturdy((BlockGetter)level, offsetPos, direction.getOpposite()) || this.mayPlaceOn(offsetState, (BlockGetter)level, offsetPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState state = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite()) : (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return state;
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public float getMaxHorizontalOffset() {
        return 0.15f;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACE});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        return WallHibiscusBlock.getConnectedDirection(state).getOpposite() == direction && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, otherState, level, pos, otherPos);
    }

    public static BlockState setPropertiesForDirection(BlockState state, Direction direction, RandomSource random) {
        return (BlockState)((BlockState)state.setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.FLOOR : (direction == Direction.DOWN ? AttachFace.CEILING : AttachFace.WALL)))).setValue((Property)FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.Plane.HORIZONTAL.getRandomDirection(random) : direction));
    }

    protected static Direction getConnectedDirection(BlockState state) {
        return switch ((AttachFace)state.getValue(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.getValue((Property)FACING);
        };
    }
}

