/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WillowSaplingBlock
extends SaplingBlock {
    protected final TreeGrower weepingTreeGrower;

    public WillowSaplingBlock(TreeGrower treeGrower, TreeGrower weepingTreeGrower, BlockBehaviour.Properties properties) {
        super(treeGrower, properties);
        this.weepingTreeGrower = weepingTreeGrower;
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if ((Integer)state.getValue((Property)STAGE) == 0) {
            level.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else {
            TreeGrower treeGrower = this.shouldBeWeepingWillow(level, pos) ? this.weepingTreeGrower : this.treeGrower;
            treeGrower.growTree(level, level.getChunkSource().getGenerator(), pos, state, random);
        }
    }

    private boolean shouldBeWeepingWillow(ServerLevel level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, -1, 1))) {
            if (!level.getFluidState(blockpos).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }
}

