/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.joml.Vector4d;

public class YakHerdingBehavior
extends Behavior<Yak> {
    public YakHerdingBehavior() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    public static BehaviorControl<Yak> createHerdingController() {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get()), (App)instance.registered((MemoryModuleType)EnvironmentalMemoryModuleTypes.SINCE_LAST_HERD.get()), (App)instance.registered((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get())).apply((Applicative)instance, (nearest, herdTicks, herdPos) -> (level, yak, gameTime) -> {
            int ticksSinceLastHerd = instance.tryGet(herdTicks).orElse(0);
            if (yak.getRandom().nextInt(400) < ticksSinceLastHerd++) {
                ticksSinceLastHerd = 0;
                List herd = (List)instance.get(nearest);
                if (herd.isEmpty()) {
                    if (instance.tryGet(herdPos).isEmpty() || yak.isLeashed()) {
                        yak.getBrain().useDefaultActivity();
                        yak.clearRestriction();
                    }
                } else if (!yak.isWithinRestriction() || instance.tryGet(herdPos).isEmpty()) {
                    Vector4d herdVec = herd.stream().map(Entity::position).reduce(new Vector4d(0.0, 0.0, 0.0, 0.0), (a, b) -> a.add(b.x, b.y, b.z, 1.0), Vector4d::add);
                    herdVec = herdVec.div(herdVec.w);
                    herdPos.setWithExpiry((Object)BlockPos.containing((double)herdVec.x, (double)herdVec.y, (double)herdVec.z), 1200L);
                }
            }
            herdTicks.set((Object)ticksSinceLastHerd);
            return true;
        }));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        return !yak.isLeashed() && !yak.isBaby() && yak.getBrain().hasMemoryValue((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get());
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        yak.getBrain().getMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get()).ifPresent(pos -> yak.restrictTo((BlockPos)pos, 10));
    }
}

