/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class YakMoveToRestrictionBehavior
extends Behavior<Yak> {
    private final float speedModifier;
    private Vec3 targetVec;

    public YakMoveToRestrictionBehavior(float speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), 150, 250);
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        if (yak.isWithinRestriction() || yak.isBaby() || yak.isLeashed()) {
            return false;
        }
        this.targetVec = DefaultRandomPos.getPosTowards((PathfinderMob)yak, (int)16, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)yak.getRestrictCenter()), (double)1.5707963267948966);
        return this.targetVec != null;
    }

    protected boolean canStillUse(ServerLevel level, Yak yak, long gameTime) {
        return !yak.getNavigation().isDone() && !yak.isWithinRestriction() && !yak.isBaby() && !yak.isLeashed();
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        yak.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(new Vec3(this.targetVec.x, this.targetVec.y, this.targetVec.z), this.speedModifier, 8));
    }

    protected void stop(ServerLevel level, Yak yak, long gameTime) {
        yak.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

