/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.brain.yak;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class YakRamBehavior
extends Behavior<Yak> {
    public static final int TIME_OUT_DURATION = 200;
    public static final float RAM_SPEED_FORCE_FACTOR = 1.65f;
    private final Function<Yak, UniformInt> getTimeBetweenRams;
    private final float speed;
    private final ToDoubleFunction<Yak> getKnockbackForce;
    private final Function<Yak, SoundEvent> getImpactSound;
    private Vec3 ramDirection;

    public YakRamBehavior(Function<Yak, UniformInt> ramCooldown, float speed, ToDoubleFunction<Yak> knockbackForce, Function<Yak, SoundEvent> impactSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.RAM_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 200);
        this.getTimeBetweenRams = ramCooldown;
        this.speed = speed;
        this.getKnockbackForce = knockbackForce;
        this.getImpactSound = impactSound;
        this.ramDirection = Vec3.ZERO;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Yak yak) {
        return yak.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    protected boolean canStillUse(ServerLevel level, Yak yak, long gameTime) {
        return yak.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    protected void start(ServerLevel level, Yak yak, long gameTime) {
        BlockPos pos = yak.blockPosition();
        Brain<Yak> brain = yak.getBrain();
        Vec3 ramTargetPos = (Vec3)brain.getMemory(MemoryModuleType.RAM_TARGET).get();
        this.ramDirection = new Vec3((double)pos.getX() - ramTargetPos.x(), 0.0, (double)pos.getZ() - ramTargetPos.z()).normalize();
        brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(ramTargetPos.add(this.ramDirection.scale(-4.0)), this.speed, 0));
    }

    protected void tick(ServerLevel level, Yak yak, long gameTime) {
        Brain<Yak> brain = yak.getBrain();
        LivingEntity attackTarget = brain.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        List list = level.getNearbyEntities(LivingEntity.class, TargetingConditions.forCombat().selector(entity -> Objects.equals(entity, attackTarget)), (LivingEntity)yak, yak.getBoundingBox());
        if (list.isEmpty()) {
            Optional destination = brain.getMemory(MemoryModuleType.WALK_TARGET);
            Optional ramTarget = brain.getMemory(MemoryModuleType.RAM_TARGET);
            if (destination.isEmpty() || ramTarget.isEmpty() || ((WalkTarget)destination.get()).getTarget().currentPosition().closerThan((Position)ramTarget.get(), 0.25)) {
                this.finishRam(level, yak);
            }
            return;
        }
        LivingEntity target = (LivingEntity)list.get(0);
        target.hurt(level.damageSources().mobAttack((LivingEntity)yak), (float)yak.getAttributeValue(Attributes.ATTACK_DAMAGE));
        int speedFactor = yak.hasEffect(MobEffects.MOVEMENT_SPEED) ? yak.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier() + 1 : 0;
        int slownessFactor = yak.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) ? yak.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1 : 0;
        float effectSpeed = 0.25f * (float)(speedFactor - slownessFactor);
        float speedForce = Mth.clamp((float)(yak.getSpeed() * 1.65f), (float)0.2f, (float)3.0f) + effectSpeed;
        float knockbackForce = target.isDamageSourceBlocked(level.damageSources().mobAttack((LivingEntity)yak)) ? 0.5f : 1.0f;
        target.knockback((double)(knockbackForce * speedForce) * this.getKnockbackForce.applyAsDouble(yak), this.ramDirection.x(), this.ramDirection.z());
        this.finishRam(level, yak);
        level.playSound(null, (Entity)yak, this.getImpactSound.apply(yak), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    protected void finishRam(ServerLevel level, Yak yak) {
        level.broadcastEntityEvent((Entity)yak, (byte)59);
        yak.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)this.getTimeBetweenRams.apply(yak).sample(level.getRandom()));
        yak.getBrain().eraseMemory(MemoryModuleType.RAM_TARGET);
    }
}

