/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class DeerFrolicGoal
extends Goal {
    private final AbstractDeer deer;
    private int jumpCooldown;
    private int frolicCooldown;
    private boolean jumping = false;

    public DeerFrolicGoal(AbstractDeer deerIn) {
        this.deer = deerIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return this.deer.isSpreadingFlowers();
    }

    public boolean canContinueToUse() {
        return this.deer.isSpreadingFlowers() || !this.deer.getNavigation().isDone();
    }

    public void start() {
        this.resetJumpCooldown();
        this.frolicCooldown = 0;
    }

    public void tick() {
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.jumping && this.deer.onGround()) {
            this.deer.spawnFlower();
            this.jumpCooldown = Math.max(this.adjustedTickDelay(2), this.jumpCooldown);
            this.jumping = false;
        } else if (this.deer.getNavigation().isDone()) {
            Vec3 vec3;
            if (this.frolicCooldown > 0) {
                --this.frolicCooldown;
            } else if (this.deer.isSpreadingFlowers() && (vec3 = DefaultRandomPos.getPos((PathfinderMob)this.deer, (int)15, (int)7)) != null) {
                this.deer.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, 1.6);
                if (this.deer.getRandom().nextInt(8) == 0) {
                    this.frolicCooldown = this.adjustedTickDelay(20 + this.deer.getRandom().nextInt(20));
                }
            }
        } else if (this.jumpCooldown <= 0 && this.deer.onGround()) {
            Path path = this.deer.getNavigation().getPath();
            Vec3 vec3 = path.getNextEntityPos((Entity)this.deer);
            Vec3 vec31 = vec3.subtract(this.deer.position());
            Vec3 vec32 = vec31.normalize();
            this.deer.level().broadcastEntityEvent((Entity)this.deer, (byte)4);
            this.deer.setJumping(true);
            this.deer.setDeltaMovement(this.deer.getDeltaMovement().add(vec32.x * 0.32, 0.5, vec32.z * 0.32));
            this.resetJumpCooldown();
            this.jumping = true;
        }
    }

    private void resetJumpCooldown() {
        this.jumpCooldown = this.adjustedTickDelay(16);
    }
}

