/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.deer;

import com.teamabnormals.environmental.common.entity.animal.deer.AbstractDeer;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class DeerRunFromAttackerGoal
extends Goal {
    private final AbstractDeer deer;
    private final PathNavigation pathNav;

    public DeerRunFromAttackerGoal(AbstractDeer deerIn) {
        this.deer = deerIn;
        this.pathNav = deerIn.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity attacker = this.deer.getLastHurtByMob();
        return attacker != null && attacker.isAlive() && EntitySelector.NO_SPECTATORS.test(attacker) && this.deer.distanceToSqr((Entity)attacker) <= 256.0;
    }

    public void start() {
        this.flee();
    }

    public void tick() {
        if (this.pathNav.isDone()) {
            this.flee();
        }
    }

    private void flee() {
        LivingEntity attacker = this.deer.getLastHurtByMob();
        Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.deer, (int)12, (int)6, (Vec3)attacker.position());
        if (vec3 != null && attacker.distanceToSqr(vec3.x, vec3.y, vec3.z) >= attacker.distanceToSqr((Entity)this.deer)) {
            Path path = this.pathNav.createPath(vec3.x, vec3.y, vec3.z, 0);
            this.pathNav.moveTo(path, (double)1.8f);
        }
    }
}

