/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.duck;

import com.teamabnormals.environmental.common.entity.animal.Duck;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DuckSwimGoal
extends Goal {
    private final Duck duck;

    public DuckSwimGoal(Duck entityIn) {
        this.duck = entityIn;
        entityIn.getNavigation().setCanFloat(true);
    }

    public boolean canUse() {
        return this.duck.isInWater() || this.duck.isInLava();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        Vec3 motion = this.duck.getDeltaMovement();
        double d0 = this.duck.getFluidHeight(FluidTags.WATER);
        double d1 = motion.y;
        if (!this.duck.isBaby() && d0 > 0.3 || this.duck.isBaby() && d0 > 0.15) {
            if (d1 < -0.02) {
                d1 *= (double)0.3f;
            } else if (!this.duck.isBaby() && d0 > 0.31 || this.duck.isBaby() && d0 > 0.16) {
                d1 += motion.y < (double)0.12f ? (double)0.03f : 0.0;
            } else if (d1 < 0.0) {
                d1 = 0.0;
            }
        }
        this.duck.setDeltaMovement(motion.x, d1, motion.z);
    }
}

