/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.slabfish;

import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class SlabbyGrabItemGoal
extends Goal
implements ContainerListener {
    private final Slabfish slabfish;
    private ItemEntity itemEntity;
    private final double moveSpeed;
    private int delayCounter;
    private boolean listening;

    public SlabbyGrabItemGoal(Slabfish animal, double speed) {
        this.slabfish = animal;
        this.moveSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private boolean canPickupItem(Container inventory, ItemStack stack) {
        for (int i = 3; i < inventory.getContainerSize(); ++i) {
            ItemStack stackInSlot = inventory.getItem(i);
            if (!stackInSlot.isEmpty() && (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackInSlot) || !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack) || stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), inventory.getMaxStackSize()))) continue;
            return true;
        }
        return false;
    }

    public boolean canUse() {
        if (!this.slabfish.hasBackpack() || this.slabfish.backpackFull || this.slabfish.isOrderedToSit()) {
            return false;
        }
        List list = this.slabfish.level().getEntitiesOfClass(ItemEntity.class, this.slabfish.getBoundingBox().inflate(12.0, 4.0, 12.0));
        ItemEntity item = null;
        double d0 = Double.MAX_VALUE;
        for (ItemEntity item1 : list) {
            double d1;
            if (item1.getOwner() == this.slabfish || !this.canPickupItem(this.slabfish.slabfishBackpack, item1.getItem()) || !((d1 = this.slabfish.distanceToSqr((Entity)item1)) < d0)) continue;
            d0 = d1;
            item = item1;
        }
        if (item == null) {
            return false;
        }
        this.itemEntity = item;
        return true;
    }

    public boolean canContinueToUse() {
        return this.slabfish.hasBackpack() && !this.slabfish.backpackFull && this.itemEntity != null && this.itemEntity.isAlive();
    }

    public void start() {
        this.delayCounter = 0;
        if (!this.listening) {
            this.listening = true;
            this.slabfish.slabfishBackpack.addListener(this);
        }
    }

    public void stop() {
        this.itemEntity = null;
    }

    public void tick() {
        if (--this.delayCounter <= 0) {
            this.delayCounter = this.adjustedTickDelay(10);
            Path path = this.slabfish.getNavigation().createPath((Entity)this.itemEntity, 0);
            if (path != null) {
                this.slabfish.getNavigation().stop();
                this.slabfish.getNavigation().moveTo(path, this.moveSpeed);
            }
        }
    }

    public void containerChanged(Container inventory) {
        ItemStack stack;
        if (this.itemEntity != null && !this.canPickupItem(inventory, stack = this.itemEntity.getItem())) {
            this.itemEntity = null;
        }
    }
}

