/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.tapir;

import com.teamabnormals.environmental.common.entity.animal.Tapir;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TapirHuntFloraGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    private final Tapir tapir;
    private Tapir partner;
    private int grazeTime;
    private int romanticDinnerTime;
    private int delayCounter;

    public TapirHuntFloraGoal(Tapir tapir) {
        this.tapir = tapir;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.tapir.getTrackingTime() > 0 && this.tapir.hasFloraPos();
    }

    public void start() {
        this.moveTo(this.tapir.getFloraPos());
        this.grazeTime = this.adjustedTickDelay(200 + this.tapir.getRandom().nextInt(100));
        this.partner = null;
        this.delayCounter = 0;
    }

    public void stop() {
        this.tapir.setRunning(false);
        this.tapir.setGrazing(false);
        this.tapir.stopTracking();
    }

    public void tick() {
        BlockPos florapos = this.tapir.getFloraPos();
        BlockState florastate = this.tapir.level().getBlockState(florapos);
        if (!florastate.getBlock().getCloneItemStack((LevelReader)this.tapir.level(), florapos, florastate).is(this.tapir.getFloraItem())) {
            if (this.tapir.isGrazing()) {
                this.tapir.stopTracking();
                return;
            }
            if (florapos.closerThan((Vec3i)this.tapir.blockPosition(), 5.0)) {
                this.tapir.level().broadcastEntityEvent((Entity)this.tapir, (byte)5);
                this.tapir.playSound((SoundEvent)EnvironmentalSoundEvents.TAPIR_REJECT.get());
                this.tapir.stopTracking();
                return;
            }
        }
        if (florapos.closerThan((Vec3i)this.tapir.blockPosition(), 1.5)) {
            this.tapir.getLookControl().setLookAt((double)florapos.getX() + 0.5, this.tapir.getEyeY(), (double)florapos.getZ() + 0.5, 10.0f, (float)this.tapir.getMaxHeadXRot());
            if (!this.tapir.isGrazing()) {
                this.tapir.setRunning(false);
                this.tapir.setGrazing(true);
                this.tapir.getNavigation().stop();
            } else {
                if (--this.grazeTime <= 0) {
                    this.tapir.level().destroyBlock(florapos, false);
                    this.tapir.stopTracking();
                    Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.tapir, (int)10, (int)7);
                    if (vec3 != null) {
                        this.moveTo(BlockPos.containing((Position)vec3));
                    }
                }
                if (this.tapir.getAge() == 0) {
                    if (this.partner == null) {
                        Tapir partner = this.findClosestPartner();
                        if (partner != null) {
                            this.partner = partner;
                            this.romanticDinnerTime = this.adjustedTickDelay(80);
                            if (this.grazeTime < this.adjustedTickDelay(200)) {
                                this.grazeTime = this.adjustedTickDelay(200);
                            }
                            if (!this.tapir.getFloraPos().equals((Object)partner.getFloraPos())) {
                                this.tapir.setFloraPos(partner.getFloraPos());
                            }
                        }
                    } else if (this.canBreedWith(this.partner) && this.tapir.getFloraPos().equals((Object)this.partner.getFloraPos())) {
                        if (--this.romanticDinnerTime <= 0) {
                            this.tapir.spawnChildFromBreeding((ServerLevel)this.tapir.level(), this.partner);
                        }
                    } else {
                        this.partner = null;
                    }
                }
            }
        } else {
            if (--this.delayCounter <= 0) {
                this.delayCounter = this.adjustedTickDelay(5);
                this.moveTo(florapos);
                this.tapir.setRunning(true);
            }
            this.tapir.getLookControl().setLookAt((double)florapos.getX() + 0.5, (double)florapos.getY() + 0.5, (double)florapos.getZ() + 0.5, 10.0f, (float)this.tapir.getMaxHeadXRot());
            this.tapir.setGrazing(false);
        }
    }

    @Nullable
    private Tapir findClosestPartner() {
        List list = this.tapir.level().getNearbyEntities(Tapir.class, PARTNER_TARGETING, (LivingEntity)this.tapir, this.tapir.getBoundingBox().inflate(8.0));
        double d0 = Double.MAX_VALUE;
        Tapir partner = null;
        for (Tapir entity : list) {
            double d1 = this.tapir.distanceToSqr((Entity)entity);
            if (!this.canBreedWith(entity) || !(d1 < d0)) continue;
            d0 = d1;
            partner = entity;
        }
        return partner;
    }

    private boolean canBreedWith(Tapir partner) {
        return partner.isGrazing() && partner.getAge() == 0 && this.tapir.getFloraItem() == partner.getFloraItem();
    }

    private void moveTo(BlockPos pos) {
        this.tapir.getNavigation().moveTo(this.tapir.getNavigation().createPath((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0), 1.1);
    }
}

