/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.ai.goal.zebroid;

import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebra;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class ZebraFleeGoal
extends Goal {
    private final Zebra zebra;
    private final PathNavigation pathNav;
    private final double speedModifier;
    private boolean trigger;
    private boolean running;
    private boolean isStuck;
    private int nextStartTicks;
    private int fleeTime;
    private int stuckTime;
    private float fleeDirection;

    public ZebraFleeGoal(Zebra zebra, double speed) {
        this.zebra = zebra;
        this.pathNav = zebra.getNavigation();
        this.speedModifier = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        List<Zebra> zebras;
        if (this.trigger) {
            return true;
        }
        if (--this.nextStartTicks > 0) {
            return false;
        }
        if (!this.zebra.isTamed() && this.zebra.getTarget() == null && !(zebras = this.zebra.level().getEntitiesOfClass(Zebra.class, this.zebra.getBoundingBox().inflate(10.0, 4.0, 10.0), zebra1 -> zebra1 != this.zebra && zebra1.isFleeing()).stream().sorted(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this.zebra))).toList()).isEmpty()) {
            Zebra zebra12 = zebras.get(0);
            this.fleeTime = zebra12.getFleeGoal().fleeTime + this.adjustedTickDelay(this.zebra.getRandom().nextInt(30) - 30);
            this.fleeDirection = zebra12.getFleeGoal().fleeDirection;
            this.nextStartTicks = this.adjustedTickDelay(60);
            return true;
        }
        this.nextStartTicks = this.adjustedTickDelay(this.zebra.getRandom().nextInt(10) + 10);
        return false;
    }

    public boolean canContinueToUse() {
        return --this.fleeTime >= 0;
    }

    public void start() {
        this.running = true;
        this.trigger = false;
        this.isStuck = false;
        this.stuckTime = 0;
        this.pathNav.stop();
        this.zebra.setEating(false);
        this.zebra.setStanding(false);
        this.zebra.playAmbientSound();
    }

    public void stop() {
        this.running = false;
    }

    public void tick() {
        if (this.pathNav.isDone() || this.pathNav.getTargetPos() != null && this.pathNav.getTargetPos().closerToCenterThan((Position)this.zebra.position(), 5.0)) {
            float f = this.fleeDirection * ((float)Math.PI / 180);
            Vec3 vec3 = this.zebra.position().add(new Vec3(Math.sin(f) * 32.0, 0.0, Math.cos(f) * 32.0));
            for (int i = 0; i < 3; ++i) {
                Vec3 vec31 = DefaultRandomPos.getPosTowards((PathfinderMob)this.zebra, (int)16, (int)7, (Vec3)vec3, (double)0.5235987755982988);
                if (vec31 == null) continue;
                double d0 = this.speedModifier;
                double d1 = this.zebra.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue();
                if (d1 < 0.225 && d1 != 0.0) {
                    d0 = 0.4 / d1;
                }
                this.pathNav.moveTo(vec31.x, vec31.y, vec31.z, d0);
                this.stuckTime = 0;
                if (this.isStuck) {
                    this.isStuck = false;
                    this.zebra.playAmbientSound();
                }
                return;
            }
            if (++this.stuckTime > this.adjustedTickDelay(20)) {
                List<Zebra> zebras = this.zebra.level().getEntitiesOfClass(Zebra.class, this.zebra.getBoundingBox().inflate(10.0, 4.0, 10.0), zebra1 -> zebra1 != this.zebra && zebra1.isFleeing() && zebra1.getFleeGoal().fleeDirection != this.fleeDirection && !zebra1.getFleeGoal().isStuck).stream().sorted(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)this.zebra))).toList();
                if (!zebras.isEmpty()) {
                    this.fleeDirection = zebras.get((int)0).getFleeGoal().fleeDirection;
                } else {
                    int i = this.zebra.getRandom().nextInt(2) - 1;
                    if (i >= 0) {
                        ++i;
                    }
                    this.fleeDirection = Mth.wrapDegrees((float)(this.fleeDirection + (float)i * 60.0f));
                }
                this.stuckTime = 0;
                this.isStuck = true;
            }
        }
    }

    public boolean running() {
        return this.running;
    }

    public void trigger(int fleeTime, float fleeDirection) {
        this.trigger = true;
        this.fleeTime = fleeTime;
        this.fleeDirection = fleeDirection;
    }
}

