/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="environmental")
public class MuddyPig {
    public static final int MAX_DRYING_TIME = 36000;

    public static boolean enabled() {
        return (Boolean)EnvironmentalConfig.COMMON.muddyPigs.get();
    }

    public static boolean isMuddy(Pig pig) {
        IDataManager data = (IDataManager)pig;
        return (Boolean)data.getValue(EnvironmentalDataProcessors.IS_MUDDY);
    }

    public static int getDryingTime(Pig pig) {
        IDataManager data = (IDataManager)pig;
        return (Integer)data.getValue(EnvironmentalDataProcessors.MUD_DRYING_TIME);
    }

    public static void setMuddy(Pig pig, boolean muddy) {
        IDataManager data = (IDataManager)pig;
        data.setValue(EnvironmentalDataProcessors.IS_MUDDY, (Object)muddy);
    }

    public static void setDryingTime(Pig pig, int amount) {
        IDataManager data = (IDataManager)pig;
        data.setValue(EnvironmentalDataProcessors.MUD_DRYING_TIME, (Object)amount);
    }

    public static void updateDryingTime(Pig pig, int amount) {
        MuddyPig.setDryingTime(pig, Mth.clamp((int)0, (int)(MuddyPig.getDryingTime(pig) + amount), (int)36000));
    }

    public static boolean canGetWet(Pig pig) {
        return pig.isInWaterOrBubble() && (Boolean)EnvironmentalConfig.COMMON.muddyPigsGetWetInWater.get() != false || pig.isInWaterOrRain() && !pig.isInWater() && (Boolean)EnvironmentalConfig.COMMON.muddyPigsGetWetInRain.get() != false;
    }

    public static void removeDecoration(Pig pig) {
        IDataManager data = (IDataManager)pig;
        data.setValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION, (Object)ResourceLocation.withDefaultNamespace((String)"empty"));
    }

    public static Optional<Item> getDecoration(Pig pig) {
        ResourceLocation decoration;
        Item item;
        IDataManager data = (IDataManager)pig;
        if (MuddyPig.isMuddy(pig) && (item = (Item)BuiltInRegistries.ITEM.get(decoration = (ResourceLocation)data.getValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION))) instanceof BlockItem) {
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onLivingSpawn(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        if (!event.isSpawnCancelled()) {
            RandomSource random = level.getRandom();
            if (entity instanceof Pig) {
                Pig pig = (Pig)entity;
                if (MuddyPig.enabled() && ((Boolean)EnvironmentalConfig.COMMON.naturalMuddyPigs.get()).booleanValue() && level.getBiome(entity.blockPosition()).is(EnvironmentalBiomeTags.HAS_MUDDY_PIG)) {
                    IDataManager data = (IDataManager)entity;
                    MuddyPig.setMuddy(pig, true);
                    MuddyPig.setDryingTime(pig, 36000);
                    if ((double)random.nextFloat() < (Double)EnvironmentalConfig.COMMON.muddyPigDecorationChance.get()) {
                        Optional item = ((HolderSet.Named)BuiltInRegistries.ITEM.getTag(EnvironmentalItemTags.SPAWNS_ON_MUDDY_PIG).get()).getRandomElement(random);
                        item.ifPresent(value -> data.setValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION, (Object)BuiltInRegistries.ITEM.getKey((Object)((Item)value.value()))));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.getCommandSenderWorld();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (entity.isAlive() && MuddyPig.isMuddy(pig)) {
                if (MuddyPig.canGetWet(pig)) {
                    MuddyPig.updateDryingTime(pig, 1);
                } else if (((Boolean)EnvironmentalConfig.COMMON.muddyPigsDryOverTime.get()).booleanValue() && (!((Boolean)EnvironmentalConfig.COMMON.muddyPigsOnlyDryInTheNether.get()).booleanValue() || level.dimensionType().ultraWarm())) {
                    MuddyPig.updateDryingTime(pig, -1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        RandomSource random = level.getRandom();
        if (target instanceof Pig) {
            Pig pig = (Pig)target;
            if (target.isAlive()) {
                IDataManager data = (IDataManager)target;
                if (MuddyPig.enabled() && MuddyPig.isMuddy(pig)) {
                    ItemEntity item;
                    boolean allowDecorating;
                    boolean dried = MuddyPig.getDryingTime(pig) <= 0;
                    Optional<Item> decoration = MuddyPig.getDecoration(pig);
                    if (decoration.isEmpty()) {
                        MuddyPig.removeDecoration(pig);
                    }
                    if (allowDecorating = ((Boolean)EnvironmentalConfig.COMMON.decoratableMuddyPigs.get()).booleanValue()) {
                        if (decoration.isEmpty()) {
                            if (stack.is(EnvironmentalItemTags.MUDDY_PIG_DECORATIONS)) {
                                data.setValue(EnvironmentalDataProcessors.MUDDY_PIG_DECORATION, (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
                                level.playSound(null, target, dried ? SoundEvents.PACKED_MUD_PLACE : SoundEvents.MUD_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
                                if (!event.getEntity().isCreative()) {
                                    stack.shrink(1);
                                }
                                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                                event.setCanceled(true);
                            }
                        } else if (stack.canPerformAction(ItemAbilities.SHEARS_CARVE)) {
                            level.playSound(null, target, SoundEvents.SNOW_GOLEM_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
                            target.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                            if (!level.isClientSide()) {
                                item = target.spawnAtLocation(new ItemStack((ItemLike)decoration.get()), 1.0f);
                                item.setDeltaMovement(item.getDeltaMovement().add((double)((random.nextFloat() - random.nextFloat()) * 0.1f), (double)(random.nextFloat() * 0.05f), (double)((random.nextFloat() - random.nextFloat()) * 0.1f)));
                                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                            }
                            MuddyPig.removeDecoration(pig);
                            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                            event.setCanceled(true);
                        }
                    }
                    if (stack.is(EnvironmentalItemTags.MUDDY_PIG_DRYING_ITEMS) && !dried) {
                        level.playSound(null, target, SoundEvents.PACKED_MUD_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!event.getEntity().isCreative()) {
                            stack.shrink(1);
                        }
                        MuddyPig.setDryingTime(pig, 0);
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                    } else if (stack.is(Tags.Items.BUCKETS_WATER)) {
                        level.playSound(null, target, SoundEvents.GENERIC_SPLASH, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)stack.getCraftingRemainingItem()));
                        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        if (!level.isClientSide) {
                            ServerLevel serverlevel = (ServerLevel)level;
                            for (int i = 0; i < 5; ++i) {
                                serverlevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, target.getX() + level.random.nextDouble(), target.getY() + 1.0, target.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                            }
                        }
                        MuddyPig.setMuddy(pig, false);
                        MuddyPig.setDryingTime(pig, 0);
                        if (decoration.isPresent()) {
                            if (!level.isClientSide()) {
                                item = target.spawnAtLocation(new ItemStack((ItemLike)decoration.get()), 1.0f);
                                item.setDeltaMovement(item.getDeltaMovement().add((double)((random.nextFloat() - random.nextFloat()) * 0.1f), (double)(random.nextFloat() * 0.05f), (double)((random.nextFloat() - random.nextFloat()) * 0.1f)));
                                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                            }
                            MuddyPig.removeDecoration(pig);
                        }
                        level.playSound(null, target, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Pig pig;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Pig && MuddyPig.getDecoration(pig = (Pig)entity).isPresent()) {
            pig.spawnAtLocation((ItemLike)MuddyPig.getDecoration(pig).get());
        }
    }
}

