/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.deer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalDeerVariants;
import java.util.Comparator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record DeerVariant(ResourceLocation texture, HolderSet<Biome> biomes, int priority) {
    public static final Codec<DeerVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(DeerVariant::texture), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(DeerVariant::biomes), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(DeerVariant::priority)).apply((Applicative)instance, DeerVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DeerVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, DeerVariant::texture, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME), DeerVariant::biomes, (StreamCodec)ByteBufCodecs.INT, DeerVariant::priority, DeerVariant::new);
    public static final Codec<Holder<DeerVariant>> CODEC = RegistryFileCodec.create(EnvironmentalRegistries.DEER_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DeerVariant>> STREAM_CODEC = ByteBufCodecs.holder(EnvironmentalRegistries.DEER_VARIANT, DIRECT_STREAM_CODEC);

    public static Holder<DeerVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> biome) {
        Registry registry = registryAccess.registryOrThrow(EnvironmentalRegistries.DEER_VARIANT);
        return (Holder)registry.holders().filter(holder -> ((DeerVariant)holder.value()).biomes().contains(biome)).max(Comparator.comparingInt(holder -> ((DeerVariant)holder.value()).priority())).or(() -> registry.getHolder(EnvironmentalDeerVariants.DEFAULT)).or(() -> ((Registry)registry).getAny()).orElseThrow();
    }
}

