/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.koi;

import com.teamabnormals.environmental.common.entity.animal.koi.KoiVariant;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalKoiVariants;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Koi
extends AbstractFish
implements VariantHolder<Holder<KoiVariant>> {
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";
    private static final EntityDataAccessor<Holder<KoiVariant>> VARIANT = SynchedEntityData.defineId(Koi.class, (EntityDataSerializer)((EntityDataSerializer)EnvironmentalDataSerializers.KOI_VARIANT.get()));
    private static final NormalNoise NOISE = NormalNoise.create((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (NormalNoise.NoiseParameters)new NormalNoise.NoiseParameters(-3, 1.3, new double[0]));
    public static final TargetingConditions PLAYERS_OR_ENDERMEN = TargetingConditions.forNonCombat().selector(entity -> entity instanceof Player || entity instanceof EnderMan).ignoreLineOfSight().ignoreInvisibilityTesting();

    public Koi(EntityType<? extends AbstractFish> type, Level world) {
        super(type, world);
        this.moveControl = new MoveHelperController(this);
        this.setPathfindingMalus(PathType.WATER, 0.4f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 4.25));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 5.0f, 1.6, 1.4, EntitySelector.NO_SPECTATORS::test));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 50));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry registry = this.registryAccess().registryOrThrow(EnvironmentalRegistries.KOI_VARIANT);
        builder.define(VARIANT, (Object)((Holder)registry.getHolder(EnvironmentalKoiVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.getVariant().unwrapKey().ifPresent(variant -> tag.putString(BUCKET_VARIANT_TAG, variant.location().toString()));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BUCKET_VARIANT_TAG))).map(loc -> ResourceKey.create(EnvironmentalRegistries.KOI_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(EnvironmentalRegistries.KOI_VARIANT).getHolder(key)).ifPresent(this::setVariant);
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> this.getVariant().unwrapKey().ifPresent(variant -> tag.putString(BUCKET_VARIANT_TAG, variant.location().toString())));
    }

    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString(BUCKET_VARIANT_TAG))).map(loc -> ResourceKey.create(EnvironmentalRegistries.KOI_VARIANT, (ResourceLocation)loc)).flatMap(key -> this.registryAccess().registryOrThrow(EnvironmentalRegistries.KOI_VARIANT).getHolder(key)).ifPresent(this::setVariant);
    }

    public void setVariant(Holder<KoiVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public Holder<KoiVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.BUCKET) {
            this.setVariant(KoiVariant.getRandomVariant(this.registryAccess(), this.random));
        } else {
            this.setVariant(this.getNoiseVariant(this.blockPosition()));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public Holder<KoiVariant> getNoiseVariant(BlockPos pos) {
        double d0 = Koi.getNoiseValue(pos, 0.25);
        double d1 = Mth.clamp((double)((1.0 + d0) / 2.0), (double)0.0, (double)0.9999);
        return KoiVariant.getNoiseVariant(this.registryAccess(), d1);
    }

    protected static double getNoiseValue(BlockPos pos, double val) {
        return NOISE.getValue((double)pos.getX() * val, (double)pos.getY() * val, (double)pos.getZ() * val);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.01f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public void tick() {
        super.tick();
        Vec3 vector3d = this.getDeltaMovement();
        if ((double)Mth.abs((float)((float)vector3d.y)) >= 0.01) {
            this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()))) * 57.2957763671875));
        } else {
            this.setXRot(0.0f);
        }
        this.setXRot(Koi.normalizeRotation(this.xRotO, this.getXRot()));
    }

    protected static float normalizeRotation(float prevRot, float rot) {
        while (rot - prevRot < -180.0f) {
            prevRot -= 360.0f;
        }
        while (rot - prevRot >= 180.0f) {
            prevRot += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)prevRot, (float)rot);
    }

    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.45f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (this.level().getGameTime() % 20L == 0L && ((Boolean)EnvironmentalConfig.COMMON.serenityEffect.get()).booleanValue()) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (LivingEntity living : this.level().getNearbyEntities(LivingEntity.class, PLAYERS_OR_ENDERMEN, (LivingEntity)this, this.getBoundingBox().inflate((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (this.level().isClientSide()) continue;
                living.addEffect(new MobEffectInstance(EnvironmentalMobEffects.SERENITY, 100, 0, true, false, true));
            }
        }
        super.aiStep();
    }

    public SoundEvent getFlopSound() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_FLOP.get();
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_AMBIENT.get();
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_DEATH.get();
    }

    public SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.KOI_HURT.get();
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)EnvironmentalItems.KOI_BUCKET.get());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 5.0);
    }

    public static boolean canKoiSpawn(EntityType<? extends AbstractFish> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.getBlockState(pos).is(Blocks.WATER) && worldIn.getBlockState(pos.above()).is(Blocks.WATER) && pos.getY() > 55;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Koi koi;

        public MoveHelperController(Koi koi) {
            super((Mob)koi);
            this.koi = koi;
        }

        public void tick() {
            if (this.koi.isEyeInFluid(FluidTags.WATER)) {
                this.koi.setDeltaMovement(this.koi.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.koi.getNavigation().isDone()) {
                double d0 = this.wantedX - this.koi.getX();
                double d1 = this.wantedY - this.koi.getY();
                double d2 = this.wantedZ - this.koi.getZ();
                double d3 = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                if (d0 != 0.0 || (d1 /= d3) != 0.0) {
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.koi.setYRot(this.rotlerp(this.koi.getYRot(), f, 15.0f));
                    this.koi.yBodyRot = this.koi.getYRot();
                    this.koi.yHeadRot = this.koi.getYRot();
                }
                float f1 = (float)(this.speedModifier * this.koi.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                this.koi.setSpeed(Mth.lerp((float)0.125f, (float)this.koi.getSpeed(), (float)f1));
                this.koi.setDeltaMovement(this.koi.getDeltaMovement().add(0.0, (double)this.koi.getSpeed() * d1 * 0.03, 0.0));
            }
        }
    }
}

