/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.yak;

import com.mojang.serialization.Dynamic;
import com.teamabnormals.environmental.common.entity.animal.yak.Yaktelligence;
import com.teamabnormals.environmental.common.item.YakPantsItem;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.IShearable;

public class Yak
extends Animal
implements IShearable,
Shearable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(Yak.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(Yak.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int grazeTimer;
    private boolean ramming;
    private int rammingTick;

    public Yak(EntityType<? extends Yak> type, Level worldIn) {
        super(type, worldIn);
    }

    protected Brain.Provider<Yak> brainProvider() {
        return Yaktelligence.createProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return Yaktelligence.createBrain(this, (Brain<Yak>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Yak> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnData) {
        Yaktelligence.createMemories(this, level.getRandom());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnData);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHEARED, (Object)false);
        builder.define(ANGER_TIME, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Sheared", this.isSheared());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSheared(compound.getBoolean("Sheared"));
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("yakBrain");
        Yaktelligence.tick(this);
        this.level().getProfiler().pop();
        if (Yaktelligence.isFighting(this.getBrain())) {
            this.lastHurtByPlayerTime = this.tickCount;
        }
        super.customServerAiStep();
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            if (this.grazeTimer > 0) {
                --this.grazeTimer;
            }
            this.rammingTick = this.ramming ? ++this.rammingTick : (this.rammingTick -= 2);
            this.rammingTick = Mth.clamp((int)this.rammingTick, (int)0, (int)10);
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 10: {
                this.grazeTimer = 40;
                break;
            }
            case 11: {
                this.grazeTimer = 0;
                break;
            }
            case 58: {
                this.ramming = true;
                break;
            }
            case 59: {
                this.ramming = false;
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Items.BUCKET) && !this.isBaby()) {
            player.playSound((SoundEvent)EnvironmentalSoundEvents.YAK_MILK.get(), 1.0f, 1.0f);
            ItemStack newStack = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance());
            player.setItemInHand(hand, newStack);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of(EnvironmentalItemTags.YAK_FOOD).test(stack);
    }

    public float getHeadEatingOffset(float partialTicks) {
        if (this.grazeTimer <= 0) {
            return 0.0f;
        }
        if (this.grazeTimer >= 4 && this.grazeTimer <= 36) {
            return 1.0f;
        }
        return this.grazeTimer < 4 ? ((float)this.grazeTimer - partialTicks) / 4.0f : -((float)(this.grazeTimer - 40) - partialTicks) / 4.0f;
    }

    public float getHeadPitch(float partialTicks) {
        float rammingPitch = (float)this.rammingTick / 10.0f * 30.0f * (float)Math.PI / 180.0f;
        if (rammingPitch != 0.0f) {
            return rammingPitch;
        }
        if (this.grazeTimer > 4 && this.grazeTimer <= 36) {
            return 0.62831855f + 0.22f * Mth.sin((float)(((float)(this.grazeTimer - 4) - partialTicks) / 32.0f * 28.7f));
        }
        return this.grazeTimer > 0 ? 0.62831855f : Mth.lerp((float)partialTicks, (float)this.xRotO, (float)this.getXRot()) * ((float)Math.PI / 180);
    }

    public void ate() {
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(SHEARED, (Object)sheared);
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level world, BlockPos pos) {
        return this.readyForShearing();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 2.5);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EnvironmentalSoundEvents.YAK_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.COW_STEP, 0.15f, 1.0f);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public float getVoicePitch() {
        return 0.8f;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.isClientSide) {
            this.setSheared(true);
            if (player != null && !player.isCreative() && !(player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof YakPantsItem)) {
                Yaktelligence.retaliate(this, (LivingEntity)player);
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int i = 4 + this.random.nextInt(12);
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((ItemLike)EnvironmentalItems.YAK_HAIR.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)EnvironmentalEntityTypes.YAK.get()).create((Level)world);
    }

    public void shear(SoundSource category) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, category, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 4 + this.random.nextInt(12);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.spawnAtLocation((ItemLike)EnvironmentalItems.YAK_HAIR.get(), 1);
            if (itementity == null) continue;
            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public boolean hurt(DamageSource damageSource, float damage) {
        Entity entity;
        boolean wasHurt = super.hurt(damageSource, damage);
        if (!this.level().isClientSide() && wasHurt && (entity = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Yaktelligence.wasHurtBy(this, entity2);
        }
        return wasHurt;
    }
}

