/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.yak;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakGrazeBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakHerdingBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakMoveToRestrictionBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakPrepareRamBehavior;
import com.teamabnormals.environmental.common.entity.ai.brain.yak.YakRamBehavior;
import com.teamabnormals.environmental.common.entity.animal.yak.Yak;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSensorTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.GameRules;

public class Yaktelligence {
    public static final int RAM_PREPARE_TIME = 10;
    public static final float RAM_KNOCKBACK_FORCE = 2.5f;
    private static final UniformInt TIME_BETWEEN_RAMS = UniformInt.of((int)20, (int)200);
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    public static final int HERD_RADIUS = 10;
    public static final int HERD_SEARCH_RADIUS = 12;
    public static final int HERD_CHECK_GUARANTEE = 400;
    public static final int HERD_MEMORY_EXPIRATION = 1200;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_HERDING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.1f;
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING = 1.1f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.1f;
    private static final float SPEED_MULTIPLIER_WHEN_RAMMING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.1f;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final ImmutableList<SensorType<? extends Sensor<? super Yak>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ADULT, (Object)SensorType.HURT_BY, (Object)((SensorType)EnvironmentalSensorTypes.YAK_TEMPTATIONS.get()), (Object)((SensorType)EnvironmentalSensorTypes.NEAREST_VISIBLE_YAKS.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.PATH, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_YAKS.get()), (Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_BABY_YAKS.get()), (Object)((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get()), (Object)MemoryModuleType.TEMPTING_PLAYER, (Object[])new MemoryModuleType[]{MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.IS_PANICKING, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.BREED_TARGET, MemoryModuleType.RAM_COOLDOWN_TICKS, MemoryModuleType.RAM_TARGET, MemoryModuleType.AVOID_TARGET, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, (MemoryModuleType)EnvironmentalMemoryModuleTypes.GRAZING_TICKS.get(), (MemoryModuleType)EnvironmentalMemoryModuleTypes.SINCE_LAST_HERD.get(), (MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get()});

    static Brain.Provider<Yak> createProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    static Brain<?> createBrain(Yak yak, Brain<Yak> brain) {
        Yaktelligence.learnCoreActivities(brain);
        Yaktelligence.learnIdleActivities(brain);
        Yaktelligence.learnAvoidActivities(brain);
        Yaktelligence.learnFightActivities(yak, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    static void createMemories(Yak yak, RandomSource random) {
        yak.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)TIME_BETWEEN_RAMS.sample(random));
    }

    private static BehaviorControl<Yak> createIdleMoveBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<Yak> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static void learnCoreActivities(Brain<Yak> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), YakHerdingBehavior.createHerdingController(), YakGrazeBehavior.createGrazeController(), (Object)StopBeingAngryIfTargetDead.create(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.RAM_COOLDOWN_TICKS)));
    }

    private static void learnIdleActivities(Brain<Yak> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create(yak -> !yak.isBaby(), Yaktelligence::findNearestValidAttackTarget)), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove((EntityType)EnvironmentalEntityTypes.YAK.get(), 1.0f, 2)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(yak -> Float.valueOf(1.1f))), (Object)Pair.of((Object)3, (Object)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)1.1f)), (Object)Pair.of((Object)4, Yaktelligence.createIdleMoveBehaviors()), (Object)Pair.of((Object)4, Yaktelligence.createIdleLookBehaviors()), (Object)Pair.of((Object)5, (Object)((Object)new YakGrazeBehavior())), (Object)Pair.of((Object)6, (Object)((Object)new YakHerdingBehavior())), (Object)Pair.of((Object)7, (Object)((Object)new YakMoveToRestrictionBehavior(1.0f)))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.RAM_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void learnAvoidActivities(Brain<Yak> yak) {
        yak.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.1f, (int)12, (boolean)true), Yaktelligence.createIdleLookBehaviors(), Yaktelligence.createIdleMoveBehaviors()), MemoryModuleType.AVOID_TARGET);
    }

    private static void learnFightActivities(Yak yak, Brain<Yak> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(target -> !Yaktelligence.isNearestValidAttackTarget(yak, target)), (Object)((Object)new YakRamBehavior(y -> TIME_BETWEEN_RAMS, 2.0f, y -> 2.5, y -> (SoundEvent)EnvironmentalSoundEvents.YAK_RAM.get())), (Object)((Object)new YakPrepareRamBehavior(y -> TIME_BETWEEN_RAMS.getMinValue(), 10, y -> (SoundEvent)EnvironmentalSoundEvents.YAK_CHARGE.get())), (Object)BehaviorBuilder.create(instance -> instance.group((App)instance.registered(MemoryModuleType.WALK_TARGET), (App)instance.registered(MemoryModuleType.LOOK_TARGET), (App)instance.present(MemoryModuleType.ATTACK_TARGET), (App)instance.registered(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES), (App)instance.absent(MemoryModuleType.RAM_TARGET)).apply((Applicative)instance, (walkTarget, lookTarget, attackTarget, nearestVisibleLivingEntities, ramTarget) -> (level, y, gameTime) -> {
            LivingEntity entity = (LivingEntity)instance.get(attackTarget);
            Optional visibleEntities = instance.tryGet(nearestVisibleLivingEntities);
            if (visibleEntities.isPresent() && ((NearestVisibleLivingEntities)visibleEntities.get()).contains(entity) && BehaviorUtils.isWithinAttackRange((Mob)yak, (LivingEntity)entity, (int)1)) {
                walkTarget.erase();
            } else {
                lookTarget.set((Object)new EntityTracker((Entity)entity, true));
                walkTarget.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)entity, false), 1.1f, 0));
            }
            return true;
        })), (Object)MeleeAttack.create((int)20)), MemoryModuleType.ATTACK_TARGET);
    }

    public static boolean isFighting(Brain<Yak> brain) {
        return brain.isActive(Activity.FIGHT);
    }

    public static List<Yak> getNearestVisibleYaks(Yak yak) {
        return yak.getBrain().getMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_YAKS.get()).orElse(Collections.emptyList());
    }

    public static List<Yak> getNearestVisibleAdultYaks(Yak yak) {
        return yak.getBrain().getMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_ADULT_YAKS.get()).orElse(Collections.emptyList());
    }

    public static List<Yak> getNearestVisibleBabyYaks(Yak yak) {
        return yak.getBrain().getMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.NEAREST_VISIBLE_BABY_YAKS.get()).orElse(Collections.emptyList());
    }

    protected static void wasHurtBy(Yak yak, LivingEntity target) {
        if (target instanceof Yak) {
            return;
        }
        if (yak.isBaby()) {
            Yaktelligence.retreatAndAlert(yak, target);
            Yaktelligence.broadcastRetreat(yak, target);
        } else {
            Yaktelligence.retaliate(yak, target);
            Yaktelligence.broadcastRetreat(yak, target);
        }
    }

    protected static void retaliate(Yak yak, LivingEntity target) {
        if (yak.getBrain().isActive(Activity.AVOID)) {
            return;
        }
        Brain<Yak> brain = yak.getBrain();
        brain.eraseMemory((MemoryModuleType)EnvironmentalMemoryModuleTypes.HERDING_POSITION.get());
        if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)yak, (LivingEntity)target) && !BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)yak, (LivingEntity)target, (double)4.0)) {
            if (target.getType() == EntityType.PLAYER && yak.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                Yaktelligence.setAngerTargetToNearestTargetablePlayerIfFound(yak, target);
                Yaktelligence.broadcastUniversalAnger(yak);
            } else {
                Yaktelligence.setAngerTarget(yak, target);
                Yaktelligence.broadcastAngerTarget(yak, target);
            }
        }
    }

    protected static void retreatAndAlert(Yak yak, LivingEntity target) {
        yak.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, 100L);
        if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)yak, (LivingEntity)target)) {
            Yaktelligence.broadcastAngerTarget(yak, target);
        }
    }

    protected static void broadcastAngerTarget(Yak yak, LivingEntity target) {
        Yaktelligence.getNearestVisibleAdultYaks(yak).forEach(y -> Yaktelligence.setAngerTargetIfCloserThanCurrent(y, target));
    }

    private static void broadcastRetreat(Yak yak, LivingEntity target) {
        Yaktelligence.getNearestVisibleBabyYaks(yak).forEach(y -> Yaktelligence.retreatAndAlert(y, target));
    }

    private static void broadcastUniversalAnger(Yak yak) {
        Yaktelligence.getNearestVisibleAdultYaks(yak).forEach(y -> Yaktelligence.getNearestVisibleTargetablePlayer(y).ifPresent(target -> Yaktelligence.setAngerTarget(y, (LivingEntity)target)));
    }

    protected static void setAngerTarget(Yak yak, LivingEntity target) {
        if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)yak, (LivingEntity)target)) {
            yak.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            yak.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)target.getUUID(), 600L);
            if (target.getType() == EntityType.PLAYER && yak.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                yak.getBrain().setMemoryWithExpiry(MemoryModuleType.UNIVERSAL_ANGER, (Object)true, 600L);
            }
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(Yak yak, LivingEntity target) {
        Optional<Player> optional = Yaktelligence.getNearestVisibleTargetablePlayer(yak);
        if (optional.isPresent()) {
            Yaktelligence.setAngerTarget(yak, (LivingEntity)optional.get());
        } else {
            Yaktelligence.setAngerTarget(yak, target);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(Yak yak, LivingEntity target) {
        Optional<LivingEntity> angerTarget = Yaktelligence.getAngerTarget(yak);
        LivingEntity livingentity = BehaviorUtils.getNearestTarget((LivingEntity)yak, angerTarget, (LivingEntity)target);
        if (angerTarget.isEmpty() || angerTarget.get() != livingentity) {
            Yaktelligence.setAngerTarget(yak, livingentity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(Yak yak) {
        return BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)yak, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
    }

    private static boolean isNearestValidAttackTarget(Yak yak, LivingEntity target) {
        return Yaktelligence.findNearestValidAttackTarget(yak).filter(entity -> entity == target).isPresent();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Yak yak) {
        Optional player;
        Brain<Yak> brain = yak.getBrain();
        Optional target = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)yak, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (target.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)yak, (LivingEntity)((LivingEntity)target.get()))) {
            return target;
        }
        if (brain.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && (player = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return player;
        }
        return Optional.empty();
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(Yak yak) {
        return yak.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) ? yak.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER) : Optional.empty();
    }

    static void tick(Yak yak) {
        Brain<Yak> brain = yak.getBrain();
        brain.tick((ServerLevel)yak.level(), (LivingEntity)yak);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.IDLE));
        yak.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }
}

