/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.network.message.ZebraJumpPayload;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalDamageTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public interface Zebroid {
    public static final AttributeModifier SPEED_MODIFIER_KICKING = new AttributeModifier(Environmental.location("kicking_speed_reduction"), -0.8, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    public static final Predicate<LivingEntity> KICKABLE_PREDICATE = living -> living.isAlive() && !living.getType().is(EnvironmentalEntityTypeTags.ZEBROIDS_DONT_KICK) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(living) && !living.isPassenger();

    public void setKickTime(int var1);

    public int getKickTime();

    default public boolean isKicking() {
        return this.getKickTime() > 0;
    }

    public boolean canJumpKick();

    public void setJumpStrength(float var1);

    public float getJumpStrength();

    public boolean isFleeing();

    public void playKickingSound();

    public void playAngrySound();

    public void setGallopSoundCounter(int var1);

    public int getGallopSoundCounter();

    public boolean canGallop();

    public void playZebroidGallopSound(SoundType var1);

    public void setKickCounter(int var1);

    public int getKickCounter();

    public void setBackKickAnim(float var1);

    public float getBackKickAnim();

    public void setBackKickAnimO(float var1);

    public float getBackKickAnimO();

    public void setFrontKickAnim(float var1);

    public float getFrontKickAnim();

    public void setFrontKickAnimO(float var1);

    public float getFrontKickAnimO();

    default public float getBackKickAnim(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.getBackKickAnimO(), (float)this.getBackKickAnim());
    }

    default public float getFrontKickAnim(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.getFrontKickAnimO(), (float)this.getFrontKickAnim());
    }

    default public float getBackKickBodyRot(float partialTick) {
        float anim = this.getBackKickAnim(partialTick);
        return anim < 5.0f ? Zebroid.smoothAnim(0.0f, 5.0f, anim) : (anim < 6.0f ? 1.0f : Zebroid.smoothAnim(10.0f, 6.0f, anim));
    }

    default public float getBackKickLegRot(float partialTick) {
        float anim = this.getBackKickAnim(partialTick);
        return anim < 5.0f ? Zebroid.smoothAnim(0.0f, 5.0f, anim) : (anim < 8.0f ? Zebroid.smoothAnim(8.0f, 5.0f, anim) : 0.0f);
    }

    default public float getFrontKickBodyRot(float partialTick) {
        float anim = this.getFrontKickAnim(partialTick);
        return anim < 6.0f ? Zebroid.smoothAnim(0.0f, 6.0f, anim) : (anim < 8.0f ? 1.0f : Zebroid.smoothAnim(12.0f, 8.0f, anim));
    }

    default public float getFrontKickLegRot(float partialTick) {
        float anim = this.getFrontKickAnim(partialTick);
        return anim < 6.0f ? Zebroid.smoothAnim(0.0f, 6.0f, anim) : (anim < 7.0f ? 1.0f : (anim < 10.0f ? Zebroid.smoothAnim(10.0f, 7.0f, anim) : 0.0f));
    }

    default public void playBackKickAnim() {
        this.setBackKickAnim(10.0f);
        this.setFrontKickAnim(0.0f);
        this.setBackKickAnimO(10.0f);
        this.setFrontKickAnimO(0.0f);
    }

    default public void playFrontKickAnim() {
        this.setBackKickAnim(0.0f);
        this.setFrontKickAnim(12.0f);
        this.setBackKickAnimO(0.0f);
        this.setFrontKickAnimO(12.0f);
    }

    default public void handleTick() {
        AbstractHorse horse = (AbstractHorse)this;
        if (horse.onGround() || horse.isInFluidType()) {
            this.setJumpStrength(-1.0f);
        }
        if (horse.isEffectiveAi() && horse.isAlive()) {
            boolean resetkickcounter = true;
            if (!horse.isBaby() && !this.isKicking()) {
                boolean isfleeing;
                LivingEntity rider = horse.getControllingPassenger();
                boolean jumpkick = this.canJumpKick();
                boolean bl = isfleeing = this.isFleeing() && !horse.isImmobile() && !horse.getNavigation().isDone();
                if (!horse.isStanding() || jumpkick) {
                    List nearby = horse.level().getEntitiesOfClass(LivingEntity.class, horse.getBoundingBox().inflate((double)0.9f), KICKABLE_PREDICATE);
                    boolean shouldkick = false;
                    boolean backkick = true;
                    for (LivingEntity living : nearby) {
                        Vec3 attackAngleVector = living.position().subtract(horse.position()).normalize();
                        attackAngleVector = new Vec3(attackAngleVector.x, 0.0, attackAngleVector.z);
                        double angle = attackAngleVector.dot(Vec3.directionFromRotation((float)0.0f, (float)horse.getVisualRotationYInDegrees()).normalize());
                        if (angle > 0.7) {
                            if (!isfleeing && !jumpkick && (rider == null || !(rider.zza > 0.0f))) continue;
                            shouldkick = true;
                            backkick = false;
                            break;
                        }
                        if (!(angle < -0.7) || jumpkick) continue;
                        if (isfleeing) {
                            shouldkick = true;
                            continue;
                        }
                        if (rider == null) {
                            if (!living.isDiscrete()) {
                                this.setKickCounter(this.getKickCounter() - 1);
                                if (this.getKickCounter() <= 0) {
                                    shouldkick = true;
                                }
                            }
                            if (shouldkick) continue;
                            resetkickcounter = false;
                            continue;
                        }
                        if (!(rider.zza <= 0.0f)) continue;
                        shouldkick = true;
                    }
                    if (shouldkick) {
                        this.kick(backkick, rider == null && !isfleeing);
                        this.playKickingSound();
                    }
                }
            } else {
                this.setKickTime(this.getKickTime() + 1);
                if (this.getKickTime() > 10) {
                    this.setKickTime(0);
                    horse.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_KICKING);
                }
            }
            if (resetkickcounter) {
                this.setKickCounter(20);
            }
        }
        float f = this.getBackKickAnim();
        this.setBackKickAnimO(f);
        if (f > 0.0f) {
            this.setBackKickAnim(f - 1.0f);
        }
        float f1 = this.getFrontKickAnim();
        this.setFrontKickAnimO(f1);
        if (f1 > 0.0f) {
            this.setFrontKickAnim(f1 - 1.0f);
        }
    }

    default public void kick(boolean backKick) {
        this.kick(backKick, false);
    }

    default public void kick(boolean backKick, boolean softBackKick) {
        AbstractHorse horse = (AbstractHorse)this;
        this.setKickTime(1);
        horse.setEating(false);
        AttributeInstance attributeinstance = horse.getAttribute(Attributes.MOVEMENT_SPEED);
        if (!attributeinstance.hasModifier(SPEED_MODIFIER_KICKING.id())) {
            attributeinstance.addTransientModifier(SPEED_MODIFIER_KICKING);
        }
        if (!backKick) {
            this.playFrontKickAnim();
            horse.level().broadcastEntityEvent((Entity)horse, (byte)8);
        } else {
            this.playBackKickAnim();
            horse.level().broadcastEntityEvent((Entity)horse, (byte)9);
        }
        List nearby = horse.level().getEntitiesOfClass(LivingEntity.class, horse.getBoundingBox().inflate(1.0), KICKABLE_PREDICATE);
        for (LivingEntity living : nearby) {
            Vec3 attackAngleVector = living.position().subtract(horse.position()).normalize();
            attackAngleVector = new Vec3(attackAngleVector.x, 0.0, attackAngleVector.z);
            float rot = horse.getVisualRotationYInDegrees();
            float x = Mth.sin((float)(rot * ((float)Math.PI / 180)));
            float z = -Mth.cos((float)(rot * ((float)Math.PI / 180)));
            double angle = attackAngleVector.dot(Vec3.directionFromRotation((float)0.0f, (float)rot).normalize());
            boolean jumpkick = this.canJumpKick();
            if (!(!backKick && angle > 0.7) && (!backKick || !(angle < -0.7))) continue;
            LivingEntity rider = horse.getControllingPassenger();
            DamageSource source = rider != null ? EnvironmentalDamageTypes.ridingZebra(horse.level(), (Entity)horse, (Entity)rider) : horse.damageSources().mobAttack((LivingEntity)horse);
            float damage = (float)horse.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float knockback = (float)horse.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
            if (jumpkick) {
                float f = this.getJumpStrength();
                if (rider != null && rider.zza <= 0.0f) {
                    f *= 0.5f;
                }
                damage += f * 6.0f;
                knockback = knockback * 0.8f + f * 1.1f;
            } else if (backKick) {
                if (!softBackKick) {
                    damage += 2.0f;
                } else if (damage > 1.0f) {
                    damage = 1.0f;
                }
                knockback *= 1.2f;
            } else {
                knockback *= 0.8f;
            }
            if (!living.hurt(source, (float)((int)damage))) continue;
            Level level = horse.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)living, (DamageSource)source);
            }
            if (!backKick) {
                living.knockback((double)knockback, (double)x, (double)z);
                continue;
            }
            living.knockback((double)knockback, (double)(-x), (double)(-z));
        }
    }

    default public void flingPassengers(boolean backFling) {
        AbstractHorse horse = (AbstractHorse)this;
        float rot = horse.getVisualRotationYInDegrees();
        float x = Mth.sin((float)(rot * ((float)Math.PI / 180)));
        float z = -Mth.cos((float)(rot * ((float)Math.PI / 180)));
        for (int i = horse.getPassengers().size() - 1; i >= 0; --i) {
            Entity passenger = (Entity)horse.getPassengers().get(i);
            passenger.stopRiding();
            Vec3 vec3 = new Vec3((double)x, 0.0, (double)z).scale((double)0.8f);
            if (backFling) {
                vec3 = vec3.scale(-1.0);
            }
            passenger.push(vec3.x, 0.8, vec3.z);
            passenger.hurtMarked = true;
        }
    }

    default public void handleTravel(boolean wasJumping) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!wasJumping && horse.isJumping() && horse.getControllingPassenger() instanceof Player) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ZebraJumpPayload((float)horse.getDeltaMovement().y), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    default public void handleLeashed(Entity entity) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!horse.isTamed() && entity instanceof LivingEntity) {
            horse.setTarget((LivingEntity)entity);
        }
    }

    default public boolean canDoIdleAnimation() {
        AbstractHorse horse = (AbstractHorse)this;
        return !this.isKicking() && horse.getMoveControl().getSpeedModifier() <= 1.0;
    }

    default public void handleStepSound(BlockPos pos, BlockState state) {
        AbstractHorse horse = (AbstractHorse)this;
        if (!state.liquid()) {
            BlockState blockstate = horse.level().getBlockState(pos.above());
            SoundType soundtype = state.getSoundType((LevelReader)horse.level(), pos, (Entity)horse);
            if (blockstate.is(Blocks.SNOW)) {
                soundtype = blockstate.getSoundType((LevelReader)horse.level(), pos, (Entity)horse);
            }
            if ((horse.isVehicle() || horse.getMoveControl().getSpeedModifier() > 1.6) && this.canGallop()) {
                this.setGallopSoundCounter(this.getGallopSoundCounter() + 1);
                if (this.getGallopSoundCounter() > 5 && this.getGallopSoundCounter() % 3 == 0) {
                    this.playZebroidGallopSound(soundtype);
                } else if (this.getGallopSoundCounter() <= 5) {
                    horse.playSound(SoundEvents.HORSE_STEP_WOOD, soundtype.getVolume() * 0.15f, soundtype.getPitch());
                }
            } else if (soundtype == SoundType.WOOD) {
                horse.playSound(SoundEvents.HORSE_STEP_WOOD, soundtype.getVolume() * 0.15f, soundtype.getPitch());
            } else {
                horse.playSound(SoundEvents.HORSE_STEP, soundtype.getVolume() * 0.15f, soundtype.getPitch());
            }
        }
    }

    default public void handlePositionRider(Entity rider, Entity.MoveFunction function) {
        AbstractHorse horse = (AbstractHorse)this;
        float f = Mth.sin((float)(horse.yBodyRot * ((float)Math.PI / 180)));
        float f1 = Mth.cos((float)(horse.yBodyRot * ((float)Math.PI / 180)));
        float f2 = 0.0f;
        float f3 = 0.0f;
        float nostandanim = 1.0f - horse.standAnimO;
        if (horse.standAnimO > 0.0f) {
            f2 += 0.7f * horse.standAnimO;
            f3 += 0.15f * horse.standAnimO;
            if (rider instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)rider;
                living.yBodyRot = horse.yBodyRot;
            }
        }
        if (this.getBackKickAnimO() > 0.0f) {
            float rot = this.getBackKickBodyRot(0.0f);
            f2 += -0.2f * rot * nostandanim;
            f3 += 0.15f * rot * nostandanim;
        } else if (this.getFrontKickAnimO() > 0.0f) {
            float rot = this.getFrontKickBodyRot(0.0f);
            f2 += 0.2f * rot * nostandanim;
            f3 += 0.15f * rot * nostandanim;
        }
        Vec3 vec3 = horse.getPassengerRidingPosition(rider).subtract(rider.getVehicleAttachmentPoint((Entity)horse));
        function.accept(rider, vec3.x() + (double)(f2 * f), vec3.y() + (double)f3, vec3.z() - (double)(f2 * f1));
    }

    public static float smoothAnim(float min, float max, float progress) {
        return 1.0f - Mth.square((float)((progress - max) / (max - min)));
    }
}

