/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item;

import com.teamabnormals.environmental.common.entity.animal.koi.KoiVariant;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class KoiBucketItem
extends MobBucketItem {
    private static final Map<String, Optional<Holder<KoiVariant>>> VARIANT_CACHE = new HashMap<String, Optional<Holder<KoiVariant>>>();

    public KoiBucketItem(Item.Properties properties) {
        super((EntityType)EnvironmentalEntityTypes.KOI.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return;
        }
        CompoundTag tag = data.copyTag();
        if (tag.contains("BucketVariantTag", 8) && context.registries() != null) {
            HolderLookup.RegistryLookup registry = context.registries().lookupOrThrow(EnvironmentalRegistries.KOI_VARIANT);
            Optional holder = VARIANT_CACHE.computeIfAbsent(tag.getString("BucketVariantTag"), s -> Optional.ofNullable(ResourceLocation.tryParse((String)s)).map(loc -> ResourceKey.create(EnvironmentalRegistries.KOI_VARIANT, (ResourceLocation)loc)).flatMap(arg_0 -> ((HolderLookup.RegistryLookup)registry).get(arg_0)));
            holder.ifPresent(koiVariantHolder -> tooltip.add((Component)((KoiVariant)koiVariantHolder.value()).description().copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})));
        }
    }
}

