/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item;

import com.teamabnormals.environmental.common.entity.projectile.ThrownMudBall;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MudBallItem
extends Item
implements ProjectileItem {
    public MudBallItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.MUD_HIT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            ThrownMudBall mudBall = new ThrownMudBall(level, (LivingEntity)player);
            mudBall.setItem(new ItemStack((ItemLike)EnvironmentalItems.MUD_BALL.get()));
            mudBall.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.6f, 1.0f);
            level.addFreshEntity((Entity)mudBall);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrownMudBall mudBall = new ThrownMudBall(level, pos.x(), pos.y(), pos.z());
        mudBall.setItem(stack);
        return mudBall;
    }
}

