/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.item;

import com.teamabnormals.environmental.common.slabfish.SlabfishBackpack;
import com.teamabnormals.environmental.common.slabfish.SlabfishSweater;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SlabfishBucketItem
extends MobBucketItem {
    private static final Map<String, Optional<Holder<SlabfishVariant>>> VARIANT_CACHE = new HashMap<String, Optional<Holder<SlabfishVariant>>>();
    private static final Map<String, Optional<Holder<SlabfishBackpack>>> BACKPACK_CACHE = new HashMap<String, Optional<Holder<SlabfishBackpack>>>();
    private static final Map<String, Optional<Holder<SlabfishSweater>>> SWEATER_CACHE = new HashMap<String, Optional<Holder<SlabfishSweater>>>();

    public SlabfishBucketItem(Item.Properties builder) {
        super((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, builder);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return;
        }
        CompoundTag tag = data.copyTag();
        HolderLookup.Provider provider = context.registries();
        if (provider != null) {
            Optional holder;
            if (tag.contains("BucketVariantTag", 8) && (holder = VARIANT_CACHE.computeIfAbsent(tag.getString("BucketVariantTag"), s -> Optional.ofNullable(ResourceLocation.tryParse((String)s)).map(loc -> ResourceKey.create(EnvironmentalRegistries.SLABFISH_VARIANT, (ResourceLocation)loc)).flatMap(key -> provider.lookupOrThrow(EnvironmentalRegistries.SLABFISH_VARIANT).get(key)))).isPresent()) {
                SlabfishVariant slabfishVariant = (SlabfishVariant)((Holder)holder.get()).value();
                tooltip.add((Component)slabfishVariant.description().copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, (ChatFormatting)SlabfishVariant.RARITIES.get(slabfishVariant.getRarity(context.level())).getSecond()}));
            }
            if (tag.contains("Age", 99) && tag.getInt("Age") < 0) {
                tooltip.add((Component)Component.translatable((String)"entity.environmental.slabfish.baby").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (tag.contains("SlabfishBackpack", 8) && (holder = BACKPACK_CACHE.computeIfAbsent(tag.getString("SlabfishBackpack"), s -> Optional.ofNullable(ResourceLocation.tryParse((String)s)).map(loc -> ResourceKey.create(EnvironmentalRegistries.SLABFISH_BACKPACK, (ResourceLocation)loc)).flatMap(key -> provider.lookupOrThrow(EnvironmentalRegistries.SLABFISH_BACKPACK).get(key)))).isPresent()) {
                SlabfishBackpack backpackType = (SlabfishBackpack)((Holder)holder.get()).value();
                tooltip.add((Component)backpackType.description().copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (tag.contains("SlabfishSweater", 8) && (holder = SWEATER_CACHE.computeIfAbsent(tag.getString("SlabfishSweater"), s -> Optional.ofNullable(ResourceLocation.tryParse((String)s)).map(loc -> ResourceKey.create(EnvironmentalRegistries.SLABFISH_SWEATER, (ResourceLocation)loc)).flatMap(key -> provider.lookupOrThrow(EnvironmentalRegistries.SLABFISH_SWEATER).get(key)))).isPresent()) {
                SlabfishSweater sweaterType = (SlabfishSweater)((Holder)holder.get()).value();
                tooltip.add((Component)sweaterType.description().copy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
    }
}

