/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.CattailBlock;
import com.teamabnormals.environmental.common.block.CattailStalkBlock;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class CattailsFeature
extends Feature<NoneFeatureConfiguration> {
    public CattailsFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        boolean place = false;
        for (int i = 0; i < this.getTries(); ++i) {
            BlockPos pos = origin.offset(random.nextInt(6) - random.nextInt(6), random.nextInt(4) - random.nextInt(4), random.nextInt(6) - random.nextInt(6));
            if (i == 0 && !level.isWaterAt(pos)) {
                return false;
            }
            int stalkCount = this.getStalkCount(random);
            BlockState belowState = level.getBlockState(pos.below());
            if (!belowState.is(EnvironmentalBlockTags.CATTAIL_PLANTABLE_ON) || !level.isWaterAt(pos) && (!level.isEmptyBlock(pos) || belowState.is(BlockTags.SAND)) || !level.isEmptyBlock(pos.above()) && (!level.isWaterAt(pos.above()) || !level.isEmptyBlock(pos.above(2)))) continue;
            boolean fluffy = belowState.is(Blocks.MUD);
            level.setBlock(pos, (BlockState)((BlockState)((Block)EnvironmentalBlocks.CATTAIL_STALK.get()).defaultBlockState().setValue((Property)CattailBlock.CATTAILS, (Comparable)Integer.valueOf(stalkCount))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER)), 2);
            if (level.isWaterAt(pos.above()) || level.isEmptyBlock(pos.above(2)) && random.nextBoolean()) {
                level.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.CATTAIL_STALK.get()).defaultBlockState().setValue((Property)CattailBlock.CATTAILS, (Comparable)Integer.valueOf(stalkCount))).setValue((Property)CattailStalkBlock.BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above()).getType() == Fluids.WATER)), 2);
                if (level.isWaterAt(pos.above()) && random.nextInt(3) == 0) {
                    level.setBlock(pos.above(2), (BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.CATTAIL_STALK.get()).defaultBlockState().setValue((Property)CattailBlock.CATTAILS, (Comparable)Integer.valueOf(stalkCount))).setValue((Property)CattailStalkBlock.BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above(2)).getType() == Fluids.WATER)), 2);
                    level.setBlock(pos.above(3), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.CATTAIL.get()).defaultBlockState().setValue((Property)CattailBlock.CATTAILS, (Comparable)Integer.valueOf(stalkCount))).setValue((Property)CattailBlock.AGE, (Comparable)Integer.valueOf(2))).setValue((Property)CattailBlock.FLUFFY, (Comparable)Boolean.valueOf(fluffy))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above(3)).getType() == Fluids.WATER))).setValue((Property)CattailBlock.TOP, (Comparable)Boolean.valueOf(true)), 2);
                } else {
                    level.setBlock(pos.above(2), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.CATTAIL.get()).defaultBlockState().setValue((Property)CattailBlock.CATTAILS, (Comparable)Integer.valueOf(stalkCount))).setValue((Property)CattailBlock.AGE, (Comparable)Integer.valueOf(2))).setValue((Property)CattailBlock.FLUFFY, (Comparable)Boolean.valueOf(fluffy))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above(2)).getType() == Fluids.WATER))).setValue((Property)CattailBlock.TOP, (Comparable)Boolean.valueOf(true)), 2);
                }
            } else {
                level.setBlock(pos.above(), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)EnvironmentalBlocks.CATTAIL.get()).defaultBlockState().setValue((Property)CattailBlock.CATTAILS, (Comparable)Integer.valueOf(stalkCount))).setValue((Property)CattailBlock.AGE, (Comparable)Integer.valueOf(2))).setValue((Property)CattailBlock.FLUFFY, (Comparable)Boolean.valueOf(fluffy))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above()).getType() == Fluids.WATER))).setValue((Property)CattailBlock.TOP, (Comparable)Boolean.valueOf(true)), 2);
            }
            place = true;
        }
        return place;
    }

    public int getTries() {
        return 384;
    }

    public int getStalkCount(RandomSource random) {
        return 1 + random.nextInt(2);
    }
}

