/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.block.DwarfSpruceHeadBlock;
import com.teamabnormals.environmental.common.block.DwarfSprucePlantBlock;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.DwarfSpruceConfiguration;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalNoiseParameters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DwarfSpruceFeature
extends Feature<DwarfSpruceConfiguration> {
    public DwarfSpruceFeature(Codec<DwarfSpruceConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<DwarfSpruceConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        DwarfSpruceConfiguration config = (DwarfSpruceConfiguration)context.config();
        ServerLevel serverlevel = level.getLevel();
        NormalNoise densitynoise = (NormalNoise)EnvironmentalNoiseParameters.DWARF_SPRUCE_DENSITY_RECEIVER.get(serverlevel);
        NormalNoise heightnoise = (NormalNoise)EnvironmentalNoiseParameters.DWARF_SPRUCE_HEIGHT_RECEIVER.get(serverlevel);
        int count = !config.useNoise() ? config.density() : Math.max(0, (int)Math.ceil((densitynoise.getValue((double)origin.getX(), 0.0, (double)origin.getZ()) + config.noiseToCountRatio()) * (double)config.density()));
        float patchheight = (float)heightnoise.getValue((double)origin.getX(), 0.0, (double)origin.getZ()) * 1.25f + 1.75f;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean placed = false;
        for (int i = 0; i < count; ++i) {
            int x = origin.getX() + random.nextInt(16);
            int z = origin.getZ() + random.nextInt(16);
            mutable.set(x, level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, x, z), z);
            if (!level.isEmptyBlock((BlockPos)mutable) || !DwarfSpruceFeature.isDirt((BlockState)level.getBlockState(mutable.below()))) continue;
            int height = Math.max(Math.round(patchheight + random.nextFloat() - random.nextFloat()), 1);
            for (int j = 1; j <= height; ++j) {
                if (j == height || !level.isEmptyBlock(mutable.above())) {
                    level.setBlock((BlockPos)mutable, (BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE.get()).defaultBlockState().setValue((Property)DwarfSpruceHeadBlock.TOP, (Comparable)Boolean.valueOf(j != 1)), 2);
                    break;
                }
                level.setBlock((BlockPos)mutable, (BlockState)((Block)EnvironmentalBlocks.DWARF_SPRUCE_PLANT.get()).defaultBlockState().setValue((Property)DwarfSprucePlantBlock.BOTTOM, (Comparable)Boolean.valueOf(j == 1)), 2);
                mutable.move(Direction.UP);
            }
            placed = true;
        }
        return placed;
    }
}

