/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.levelgen.feature.configurations.FallenLeavesConfiguration;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class FallenLeavesFeature
extends Feature<FallenLeavesConfiguration> {
    public FallenLeavesFeature(Codec<FallenLeavesConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<FallenLeavesConfiguration> context) {
        FallenLeavesConfiguration config = (FallenLeavesConfiguration)context.config();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        Set<BlockPos> positions = FallenLeavesFeature.placeLeaves(config.radius(), config.ySpread(), context.origin(), (LevelSimulatedReader)context.level(), context.random());
        if (!positions.isEmpty()) {
            for (BlockPos blockpos : positions) {
                level.setBlock(blockpos, config.provider().getState(random, blockpos), 2);
            }
            return true;
        }
        return false;
    }

    public static Set<BlockPos> placeLeaves(int radius, int ySpread, BlockPos origin, LevelSimulatedReader level, RandomSource random) {
        HashSet positions = Sets.newHashSet();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int ditheroffset = random.nextBoolean() ? 1 : 0;
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int z = -radius; z <= radius; ++z) {
                if (Math.abs(x) >= radius && Math.abs(z) >= radius - 1 || Math.abs(x) >= radius - 1 && Math.abs(z) >= radius) continue;
                for (int y = ySpread; y >= -ySpread; --y) {
                    mutable.set(origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                    float leafdensity = 1.0f - (float)Math.max(Math.abs(x), Math.abs(z)) / ((float)radius * 2.0f);
                    leafdensity += random.nextFloat() * 0.35f;
                    if (Math.abs(x + z + 2 * radius) % 2 == ditheroffset) {
                        leafdensity -= 0.45f;
                    }
                    if (!(leafdensity >= 0.5f) || !level.isStateAtPosition((BlockPos)mutable, BlockBehaviour.BlockStateBase::isAir) || !Feature.isGrassOrDirt((LevelSimulatedReader)level, (BlockPos)mutable.below())) continue;
                    positions.add(mutable.immutable());
                    continue block1;
                }
            }
        }
        return positions;
    }
}

