/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import com.teamabnormals.environmental.common.block.ColoredWisteriaLeavesBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class WisteriaTreeFeature
extends BlueprintTreeFeature {
    public WisteriaTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context, BlueprintTreeFeature.TreeInfo info) {
        TreeConfiguration config = (TreeConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int trunkHeight = config.trunkPlacer.getTreeHeight(random);
        for (int y = 0; y < trunkHeight; ++y) {
            info.addLog(origin.above(y));
        }
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.set((Vec3i)origin.above(trunkHeight - 2).relative(direction));
        for (int y = 0; y < 3; ++y) {
            info.addLog((BlockPos)pos.set((Vec3i)pos.above()));
        }
        ArrayList rootDirections = Lists.newArrayList();
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            if (!WisteriaTreeFeature.isGrassOrDirt((LevelSimulatedReader)context.level(), (BlockPos)origin.relative(direction1).below()) || trunkHeight <= 2 && direction1 == direction) continue;
            rootDirections.add(direction1);
        }
        if (!rootDirections.isEmpty()) {
            info.addLog(origin.relative((Direction)rootDirections.get(random.nextInt(rootDirections.size()))));
        }
        pos.set((Vec3i)pos.below().relative(Direction.Plane.HORIZONTAL.getRandomDirection(random)));
        for (int y = 0; y < 3; ++y) {
            info.addLog((BlockPos)pos.set((Vec3i)pos.above()));
        }
        Direction direction1 = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        Direction offset = direction1.getClockWise().getOpposite();
        Set<Direction> directions = Set.of(direction1, direction1.getOpposite(), direction1.getClockWise());
        directions.forEach(branchDirection -> {
            BlockPos.MutableBlockPos branchPos = branchDirection == direction1 ? pos.relative(offset) : pos;
            int height = random.nextInt(2);
            if (height > 0) {
                info.addLog(pos.above());
            }
            this.createBranch(branchPos.relative(branchDirection).above(height), (Direction)branchDirection, random, config, info);
        });
    }

    private void createBranch(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config, BlueprintTreeFeature.TreeInfo info) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.set((Vec3i)pos);
        info.addLog((BlockPos)mutablePos);
        info.addLog((BlockPos)mutablePos.set((Vec3i)mutablePos.relative(direction)));
        info.addLog((BlockPos)mutablePos.set((Vec3i)mutablePos.relative(direction).above()));
        this.createLeaves((BlockPos)mutablePos, direction, random, config, info);
    }

    private void createLeaves(BlockPos pos, Direction direction, RandomSource random, TreeConfiguration config, BlueprintTreeFeature.TreeInfo info) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                int i = -1 - (random.nextInt(3) == 0 ? 1 : 0);
                int j = i < -1 && random.nextInt(2) == 0 ? -1 : 0;
                for (int y = 1; y >= i; --y) {
                    if (y > 0 && x != 0 && z != 0 && random.nextInt(3) != 0) continue;
                    BlockPos blockpos = pos.offset(x, y, z);
                    if (y > j || y == 0 && x == -direction.getStepX() && z == -direction.getStepZ()) {
                        info.addFoliage(blockpos, ((Block)EnvironmentalBlocks.WISTERIA_LEAVES.get()).defaultBlockState());
                        continue;
                    }
                    if (y == j) {
                        info.addFoliage(blockpos, (BlockState)config.foliageProvider.getState(random, blockpos).setValue(ColoredWisteriaLeavesBlock.HALF, (Comparable)Half.TOP));
                        continue;
                    }
                    info.addFoliage(blockpos, config.foliageProvider.getState(random, blockpos));
                }
            }
        }
    }

    public BlockState getSapling() {
        return ((Block)EnvironmentalBlocks.BLUE_WISTERIA_SAPLING.get()).defaultBlockState();
    }
}

