/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebra;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class ZebraDazzleFeature
extends Feature<NoneFeatureConfiguration> {
    public ZebraDazzleFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        ArrayList zebras = Lists.newArrayList();
        int spawnedZebras = 0;
        int zebraCount = 18 + random.nextInt(3) + random.nextInt(3) + random.nextInt(3);
        for (int i = 0; i < 64; ++i) {
            Zebra zebra;
            int spawnRange = 8;
            double d0 = (double)pos.getX() + (random.nextDouble() - random.nextDouble()) * (double)spawnRange + 0.5;
            double d2 = (double)pos.getZ() + (random.nextDouble() - random.nextDouble()) * (double)spawnRange + 0.5;
            BlockPos spawnPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((int)d0, pos.getY(), (int)d2));
            double d1 = spawnPos.getY();
            if (!level.noCollision(((EntityType)EnvironmentalEntityTypes.ZEBRA.get()).getSpawnAABB(d0, d1, d2)) || spawnedZebras >= zebraCount || !level.getBlockState(spawnPos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) || (zebra = (Zebra)((EntityType)EnvironmentalEntityTypes.ZEBRA.get()).create((Level)level.getLevel())) == null) continue;
            zebras.add(Pair.of((Object)zebra, (Object)new Vec3(d0, d1, d2)));
            ++spawnedZebras;
        }
        if (zebras.size() > 16) {
            for (Pair pair : zebras) {
                Zebra zebra = (Zebra)pair.getFirst();
                Vec3 zebraPos = (Vec3)pair.getSecond();
                zebra.moveTo(zebraPos.x(), zebraPos.y(), zebraPos.z(), level.getRandom().nextFloat() * 360.0f, 0.0f);
                zebra.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(zebra.blockPosition()), MobSpawnType.STRUCTURE, null);
                zebra.setBaby(random.nextFloat() < 0.1f);
                level.addFreshEntity((Entity)zebra);
                zebra.spawnAnim();
            }
            return true;
        }
        return false;
    }
}

