/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.environmental.common.block.HangingWisteriaLeavesBlock;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HangingWisteriaDecorator
extends TreeDecorator {
    public static final MapCodec<HangingWisteriaDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(HangingWisteriaDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public HangingWisteriaDecorator(float probability) {
        this.probability = probability;
    }

    public void place(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.level();
        RandomSource random = context.random();
        BlockState state = this.getBlockForLeaf();
        for (BlockPos pos : context.leaves()) {
            int maxLength;
            for (maxLength = 0; maxLength < 2 && level.isStateAtPosition(pos.below(maxLength + 1), BlockBehaviour.BlockStateBase::isAir); ++maxLength) {
            }
            if (maxLength <= 0) continue;
            int actualLength = maxLength == 2 ? (random.nextInt(3) != 0 ? 2 : 1) : 1;
            for (int i = 1; i <= actualLength; ++i) {
                context.setBlock(pos.below(i), (BlockState)state.setValue(HangingWisteriaLeavesBlock.HALF, (Comparable)(i == actualLength ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER)));
            }
        }
    }

    public BlockState getBlockForLeaf() {
        if (this.probability < 0.25f) {
            return ((Block)EnvironmentalBlocks.WHITE_HANGING_WISTERIA_LEAVES.get()).defaultBlockState();
        }
        if (this.probability < 0.5f) {
            return ((Block)EnvironmentalBlocks.BLUE_HANGING_WISTERIA_LEAVES.get()).defaultBlockState();
        }
        if (this.probability < 0.75f) {
            return ((Block)EnvironmentalBlocks.PURPLE_HANGING_WISTERIA_LEAVES.get()).defaultBlockState();
        }
        return ((Block)EnvironmentalBlocks.PINK_HANGING_WISTERIA_LEAVES.get()).defaultBlockState();
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)EnvironmentalTreeDecorators.HANGING_WISTERIA_LEAVES.get();
    }
}

