/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.treedecorators;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.environmental.core.registry.EnvironmentalTreeDecorators;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PinePodzolDecorator
extends TreeDecorator {
    public static final MapCodec<PinePodzolDecorator> CODEC;
    public static final PinePodzolDecorator INSTANCE;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)EnvironmentalTreeDecorators.PINE_PODZOL.get();
    }

    public void place(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.level();
        BlockPos origin = ((BlockPos)context.logs().get(0)).below();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1 || (x != 0 || z != 0) && context.random().nextInt(4) != 0) continue;
                mutable.set((Vec3i)origin.offset(x, 0, z));
                if (!Feature.isGrassOrDirt((LevelSimulatedReader)level, (BlockPos)mutable)) continue;
                context.setBlock((BlockPos)mutable, Blocks.PODZOL.defaultBlockState());
                mutable.move(Direction.UP);
                if (!level.isStateAtPosition((BlockPos)mutable, BlockBehaviour.BlockStateBase::isAir)) continue;
                context.setBlock((BlockPos)mutable, Blocks.SHORT_GRASS.defaultBlockState());
            }
        }
    }

    static {
        INSTANCE = new PinePodzolDecorator();
        CODEC = MapCodec.unit(() -> INSTANCE);
    }
}

