/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.item.ItemStack;

public abstract class DynamicInventory
implements Container {
    private final Int2ObjectOpenHashMap<ItemStack> inventory;
    private Set<ContainerListener> listeners;
    private RegistryAccess registry;

    public DynamicInventory(RegistryAccess registryAccess) {
        this.registry = registryAccess;
        this.inventory = new Int2ObjectOpenHashMap();
        this.listeners = null;
    }

    private int getNextEmptySlot(ItemStack stack, int loopStart, int loopEnd) {
        for (int i = loopStart; i < loopEnd; ++i) {
            if (!this.canPlaceItem(i, stack) || !((ItemStack)this.inventory.getOrDefault(i, (Object)ItemStack.EMPTY)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private void mergeStacks(ItemStack stack, ItemStack stackInSlot, int index) {
        int maxStackSize = Math.min(this.getSlotStackLimit(index), stackInSlot.getMaxStackSize());
        int addAmount = Math.min(stack.getCount(), maxStackSize - stackInSlot.getCount());
        if (addAmount > 0) {
            stackInSlot.grow(addAmount);
            stack.shrink(addAmount);
        }
    }

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ContainerListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public ItemStack addItem(ItemStack stack) {
        return this.addItem(stack, 0, this.getContainerSize());
    }

    public ItemStack addItem(ItemStack stack, int startIndex, int endIndex) {
        int index;
        int loopStart = Math.max(0, startIndex);
        int loopEnd = Math.min(this.getContainerSize(), endIndex);
        ItemStack copy = stack.copy();
        for (int i = loopStart; i < loopEnd; ++i) {
            ItemStack stackInSlot = this.getItem(i);
            if (!this.canPlaceItem(i, stack) || !ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)copy) || !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)copy)) continue;
            this.mergeStacks(copy, stackInSlot, i);
            if (!copy.isEmpty()) continue;
            this.setChanged();
            return ItemStack.EMPTY;
        }
        while (!copy.isEmpty() && (index = this.getNextEmptySlot(copy, loopStart, loopEnd)) >= 0) {
            if (copy.getCount() > this.getSlotStackLimit(index)) {
                this.inventory.put(index, (Object)copy.split(this.getSlotStackLimit(index)));
                continue;
            }
            this.inventory.put(index, (Object)copy.copy());
            copy = ItemStack.EMPTY;
        }
        if (!ItemStack.matches((ItemStack)stack, (ItemStack)copy)) {
            this.setChanged();
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.EMPTY);
    }

    public ItemStack removeItem(int index, int count) {
        if (((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.EMPTY)).isEmpty() || count <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.EMPTY)).split(count);
        this.setChanged();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.EMPTY)).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = (ItemStack)this.inventory.remove(index);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        if (index < 0 || index >= this.getContainerSize()) {
            return;
        }
        this.inventory.put(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getSlotStackLimit(index)) {
            stack.setCount(this.getSlotStackLimit(index));
        }
        this.setChanged();
    }

    public void setChanged() {
        if (this.listeners == null) {
            return;
        }
        for (ContainerListener listener : this.listeners) {
            listener.containerChanged((Container)this);
        }
    }

    public int getSlotStackLimit(int index) {
        return this.getMaxStackSize();
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag slotNbt = new CompoundTag();
            slotNbt.putByte("Slot", (byte)i);
            list.add((Object)stack.save((HolderLookup.Provider)this.registry, (Tag)slotNbt));
        }
        nbt.put("Items", (Tag)list);
    }

    public void read(CompoundTag nbt) {
        this.clearContent();
        ListTag list = nbt.getList("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slotNbt = list.getCompound(i);
            int index = slotNbt.getByte("Slot") & 0xFF;
            if (index >= this.getContainerSize()) continue;
            ItemStack.parse((HolderLookup.Provider)this.registry, (Tag)slotNbt).ifPresent(stack -> this.inventory.put(index, stack));
        }
    }
}

