/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.common.slabfish.SlabfishBackpack;
import com.teamabnormals.environmental.common.slabfish.SlabfishHelper;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalSlabfishVariantTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;

public record SlabfishVariant(Component description, ResourceLocation texture, Optional<Holder<SlabfishBackpack>> backpackOverride, int priority, SlabfishCondition[] conditions) implements Predicate<SlabfishConditionContext>
{
    public static final Map<TagKey<SlabfishVariant>, Pair<Float, ChatFormatting>> RARITIES = (Map)Util.make(new HashMap(), map -> {
        map.put(EnvironmentalSlabfishVariantTags.COMMON, Pair.of((Object)Float.valueOf(1.0f), (Object)ChatFormatting.GRAY));
        map.put(EnvironmentalSlabfishVariantTags.UNCOMMON, Pair.of((Object)Float.valueOf(0.6f), (Object)ChatFormatting.GREEN));
        map.put(EnvironmentalSlabfishVariantTags.RARE, Pair.of((Object)Float.valueOf(0.25f), (Object)ChatFormatting.AQUA));
        map.put(EnvironmentalSlabfishVariantTags.EPIC, Pair.of((Object)Float.valueOf(0.05f), (Object)ChatFormatting.LIGHT_PURPLE));
        map.put(EnvironmentalSlabfishVariantTags.LEGENDARY, Pair.of((Object)Float.valueOf(0.01f), (Object)ChatFormatting.GOLD));
    });
    public static final Codec<SlabfishVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(entry -> entry.description), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(entry -> entry.texture), (App)RegistryFixedCodec.create(EnvironmentalRegistries.SLABFISH_BACKPACK).optionalFieldOf("backpack_override").forGetter(entry -> entry.backpackOverride), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(entry -> entry.priority), (App)SlabfishCondition.CODEC.listOf().xmap(list -> (SlabfishCondition[])list.toArray(SlabfishCondition[]::new), Arrays::asList).fieldOf("conditions").forGetter(entry -> entry.conditions)).apply((Applicative)instance, SlabfishVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SlabfishVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, SlabfishVariant::description, (StreamCodec)ResourceLocation.STREAM_CODEC, SlabfishVariant::texture, (StreamCodec)ByteBufCodecs.optional(SlabfishBackpack.STREAM_CODEC), SlabfishVariant::backpackOverride, (StreamCodec)ByteBufCodecs.INT, SlabfishVariant::priority, (StreamCodec)ByteBufCodecs.fromCodec((Codec)SlabfishCondition.CODEC.listOf().xmap(list -> (SlabfishCondition[])list.toArray(SlabfishCondition[]::new), Arrays::asList)), SlabfishVariant::conditions, SlabfishVariant::new);
    public static final Codec<Holder<SlabfishVariant>> CODEC = RegistryFileCodec.create(EnvironmentalRegistries.SLABFISH_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SlabfishVariant>> STREAM_CODEC = ByteBufCodecs.holder(EnvironmentalRegistries.SLABFISH_VARIANT, DIRECT_STREAM_CODEC);

    @Override
    public boolean test(SlabfishConditionContext slabfishEntity) {
        for (SlabfishCondition condition : this.conditions) {
            if (condition.test(slabfishEntity)) continue;
            return false;
        }
        return true;
    }

    public Holder<SlabfishVariant> holder(Level level) {
        Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(level.registryAccess());
        return registry.getHolderOrThrow((ResourceKey)registry.getResourceKey((Object)this).get());
    }

    public boolean is(Level level, TagKey<SlabfishVariant> tag) {
        Registry<SlabfishVariant> registry = SlabfishHelper.slabfishTypes(level.registryAccess());
        Optional set = registry.getTag(tag);
        if (set.isEmpty()) {
            return false;
        }
        return ((HolderSet.Named)set.get()).contains(this.holder(level));
    }

    public static boolean canBeSold(Holder<SlabfishVariant> variant) {
        return !variant.is(EnvironmentalSlabfishVariantTags.NOT_SOLD_BY_WANDERING_TRADER);
    }

    public static boolean isTranslucent(Holder<SlabfishVariant> variant) {
        return variant.is(EnvironmentalSlabfishVariantTags.TRANSLUCENT);
    }

    public static TagKey<SlabfishVariant> getRandomRarity(float chance) {
        return (TagKey)RARITIES.entrySet().stream().filter(value -> chance < ((Float)((Pair)value.getValue()).getFirst()).floatValue()).sorted(Comparator.comparingDouble(value -> ((Float)((Pair)value.getValue()).getFirst()).floatValue())).toList().getFirst().getKey();
    }

    public TagKey<SlabfishVariant> getRarity(Level level) {
        for (Map.Entry<TagKey<SlabfishVariant>, Pair<Float, ChatFormatting>> entry : RARITIES.entrySet()) {
            if (!this.is(level, entry.getKey())) continue;
            return entry.getKey();
        }
        return EnvironmentalSlabfishVariantTags.COMMON;
    }
}

