/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.stream.Stream;

public class XorMapCodec<F, S>
extends MapCodec<Either<F, S>> {
    private final MapCodec<F> first;
    private final MapCodec<S> second;

    public XorMapCodec(MapCodec<F> first, MapCodec<S> second) {
        this.first = first;
        this.second = second;
    }

    public <T> DataResult<Either<F, S>> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult firstRead = this.first.decode(ops, input).map(Either::left);
        DataResult secondRead = this.second.decode(ops, input).map(Either::right);
        Optional firstResult = firstRead.result();
        Optional secondResult = secondRead.result();
        if (firstResult.isPresent() && secondResult.isPresent()) {
            return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + String.valueOf(firstResult.get()) + " second: " + String.valueOf(secondResult.get()), (Object)((Either)firstResult.get()));
        }
        if (firstResult.isPresent()) {
            return firstRead;
        }
        if (secondResult.isPresent()) {
            return secondRead;
        }
        return firstRead.apply2((f, s) -> s, secondRead);
    }

    public <T> RecordBuilder<T> encode(Either<F, S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return (RecordBuilder)input.map(value1 -> this.first.encode(value1, ops, prefix), value2 -> this.second.encode(value2, ops, prefix));
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.concat(this.first.keys(ops), this.second.keys(ops));
    }

    public static <F, S> MapCodec<Either<F, S>> xor(MapCodec<F> first, MapCodec<S> second) {
        return new XorMapCodec<F, S>(first, second);
    }
}

