/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SlabfishConditionContext {
    private final ServerLevel level;
    private final Event event;
    private final Supplier<RandomSource> random;
    private final Supplier<String> name;
    private final Supplier<BlockPos> pos;
    private final Supplier<Holder<Biome>> biome;
    private final Supplier<Boolean> inRaid;
    private final Supplier<BlockState> inBlock;
    private final Supplier<FluidState> inFluid;
    private final Supplier<Time> time;
    private final Supplier<Integer> light;
    private final Map<LightLayer, Supplier<Integer>> lightTypes;
    private final Supplier<ResourceKey<Level>> dimension;
    private final Supplier<Holder<SlabfishVariant>> slabfishType;
    private final Supplier<Boolean> breederInsomnia;
    private final Pair<Holder<SlabfishVariant>, Holder<SlabfishVariant>> parents;

    private SlabfishConditionContext(Slabfish slabfish, Event event, @Nullable ServerPlayer breeder, @Nullable Slabfish parent1, @Nullable Slabfish parent2) {
        this.level = (ServerLevel)slabfish.getCommandSenderWorld();
        this.event = event;
        this.random = Suppliers.memoize(() -> ((ServerLevel)this.level).getRandom());
        this.name = Suppliers.memoize(() -> slabfish.getDisplayName().getString().trim());
        this.pos = Suppliers.memoize(() -> new BlockPos((Vec3i)slabfish.blockPosition()));
        this.biome = Suppliers.memoize(() -> this.level.getBiome(this.pos.get()));
        this.inRaid = Suppliers.memoize(() -> this.level.getRaidAt(this.pos.get()) != null);
        this.inBlock = Suppliers.memoize(() -> this.level.getBlockState(this.pos.get()));
        this.inFluid = Suppliers.memoize(() -> this.level.getFluidState(this.pos.get()));
        this.time = Suppliers.memoize(() -> this.level.isDay() ? Time.DAY : Time.NIGHT);
        this.light = Suppliers.memoize(() -> this.level.getMaxLocalRawBrightness(this.pos.get()));
        this.lightTypes = new HashMap<LightLayer, Supplier<Integer>>();
        for (LightLayer lightType : LightLayer.values()) {
            this.lightTypes.put(lightType, (Supplier<Integer>)Suppliers.memoize(() -> this.level.getBrightness(lightType, this.pos.get())));
        }
        this.dimension = Suppliers.memoize(() -> ((ServerLevel)this.level).dimension());
        this.slabfishType = Suppliers.memoize(slabfish::getVariant);
        this.breederInsomnia = Suppliers.memoize(() -> breeder != null && breeder.getStats().getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST)) >= 72000 && this.level.isNight());
        this.parents = parent1 != null && parent2 != null ? new ImmutablePair(parent1.getVariant(), parent2.getVariant()) : null;
    }

    public static SlabfishConditionContext spawned(Slabfish slabfish) {
        return new SlabfishConditionContext(slabfish, Event.SPAWN, null, null, null);
    }

    public static SlabfishConditionContext rename(Slabfish slabfish) {
        return new SlabfishConditionContext(slabfish, Event.RENAME, null, null, null);
    }

    public static SlabfishConditionContext lightning(Slabfish slabfish) {
        return new SlabfishConditionContext(slabfish, Event.LIGHTNING, null, null, null);
    }

    public static SlabfishConditionContext breeding(Slabfish slabfish, @Nullable ServerPlayer breeder, Slabfish parent1, Slabfish parent2) {
        return new SlabfishConditionContext(slabfish, Event.BREED, breeder, parent1, parent2);
    }

    public Event getEvent() {
        return this.event;
    }

    public RandomSource getRandom() {
        return this.random.get();
    }

    public String getName() {
        return this.name.get();
    }

    public BlockPos getPos() {
        return this.pos.get();
    }

    public Holder<Biome> getBiome() {
        return this.biome.get();
    }

    public Time getTime() {
        return this.time.get();
    }

    public boolean isInRaid() {
        return this.inRaid.get();
    }

    public Holder<Block> getBlock() {
        return this.inBlock.get().getBlockHolder();
    }

    public Holder<Fluid> getFluid() {
        return this.inFluid.get().holder();
    }

    public int getLight() {
        return this.light.get();
    }

    public int getLightFor(LightLayer lightType) {
        return this.lightTypes.get(lightType).get();
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension.get();
    }

    public Holder<SlabfishVariant> getSlabfishType() {
        return this.slabfishType.get();
    }

    public boolean isBreederInsomnia() {
        return this.breederInsomnia.get();
    }

    @Nullable
    public Pair<Holder<SlabfishVariant>, Holder<SlabfishVariant>> getParentTypes() {
        return this.parents;
    }

    public static enum Event implements StringRepresentable
    {
        SPAWN("spawn"),
        RENAME("rename"),
        LIGHTNING("lightning"),
        BREED("breed");

        private static final Map<String, Event> BY_NAME;
        public static final Codec<Event> CODEC;
        private final String name;

        private Event(String name) {
            this.name = name;
        }

        @Nullable
        public static Event byName(String name) {
            return BY_NAME.get(name);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(Event.values()).collect(Collectors.toMap(Event::getSerializedName, Function.identity()));
            CODEC = StringRepresentable.fromEnum(Event::values);
        }
    }

    public static enum Time implements StringRepresentable
    {
        DAY("day"),
        NIGHT("night");

        private static final Map<String, Time> BY_NAME;
        public static final Codec<Time> CODEC;
        private final String name;

        private Time(String name) {
            this.name = name;
        }

        @Nullable
        public static Time byName(String name) {
            return BY_NAME.get(name);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(Time.values()).collect(Collectors.toMap(Time::getSerializedName, Function.identity()));
            CODEC = StringRepresentable.fromEnum(Time::values);
        }
    }
}

