/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.slabfish.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.environmental.common.slabfish.SlabfishConditionType;
import com.teamabnormals.environmental.common.slabfish.XorMapCodec;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishCondition;
import com.teamabnormals.environmental.common.slabfish.condition.SlabfishConditionContext;
import com.teamabnormals.environmental.core.registry.EnvironmentalSlabfishConditions;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.level.LightLayer;

public class SlabfishLightCondition
implements SlabfishCondition {
    private static final Codec<LightLayer> LIGHT_LAYER_CODEC = Codec.STRING.comapFlatMap(name -> {
        for (LightLayer lightType : LightLayer.values()) {
            if (!lightType.name().equalsIgnoreCase((String)name)) continue;
            return DataResult.success((Object)lightType);
        }
        return DataResult.error(() -> "Invalid light type: " + name);
    }, lightLayer -> lightLayer.name().toLowerCase(Locale.ROOT));
    private static final MapCodec<SlabfishLightCondition> VALUE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("value").forGetter(SlabfishLightCondition::getMax), (App)LIGHT_LAYER_CODEC.optionalFieldOf("light_type").forGetter(c -> Optional.ofNullable(c.getLightLayer()))).apply((Applicative)instance, (value, light) -> new SlabfishLightCondition((int)value, (int)value, light.orElse(null))));
    private static final MapCodec<SlabfishLightCondition> MIN_MAX_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(SlabfishLightCondition::getMin), (App)Codec.INT.fieldOf("max").forGetter(SlabfishLightCondition::getMax), (App)LIGHT_LAYER_CODEC.optionalFieldOf("light_type").forGetter(c -> Optional.ofNullable(c.getLightLayer()))).apply((Applicative)instance, (min, max, light) -> new SlabfishLightCondition((int)min, (int)max, light.orElse(null))));
    public static final MapCodec<SlabfishLightCondition> CODEC = XorMapCodec.xor(VALUE_CODEC, MIN_MAX_CODEC).xmap(c -> c.left().isPresent() ? (SlabfishLightCondition)c.left().get() : (SlabfishLightCondition)c.right().orElse(null), c -> c.getMin() == c.getMax() ? Either.left((Object)c) : Either.right((Object)c));
    private final int min;
    private final int max;
    private final LightLayer lightLayer;
    private final Function<SlabfishConditionContext, Integer> lightGetter;

    public SlabfishLightCondition(int min, int max, @Nullable LightLayer lightLayer) {
        this.min = min;
        this.max = max;
        this.lightLayer = lightLayer;
        this.lightGetter = context -> lightLayer == null ? context.getLight() : context.getLightFor(lightLayer);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Nullable
    public LightLayer getLightLayer() {
        return this.lightLayer;
    }

    @Override
    public boolean test(SlabfishConditionContext context) {
        return this.lightGetter.apply(context) >= this.min && this.lightGetter.apply(context) <= this.max;
    }

    @Override
    public SlabfishConditionType getType() {
        return (SlabfishConditionType)EnvironmentalSlabfishConditions.LIGHT_LEVEL.get();
    }
}

