/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.environmental.client.resources.SlabfishSpriteUploader;
import com.teamabnormals.environmental.common.network.message.OpenSlabfishInventoryPayload;
import com.teamabnormals.environmental.common.network.message.ZebraJumpPayload;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.data.client.EnvironmentalBlockStateProvider;
import com.teamabnormals.environmental.core.data.client.EnvironmentalItemModelProvider;
import com.teamabnormals.environmental.core.data.client.EnvironmentalSpriteSourceProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalAdvancementProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalDataMapProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalDatapackProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalLootTableProvider;
import com.teamabnormals.environmental.core.data.server.EnvironmentalRecipeProvider;
import com.teamabnormals.environmental.core.data.server.modifiers.EnvironmentalAdvancementModifierProvider;
import com.teamabnormals.environmental.core.data.server.modifiers.EnvironmentalChunkGeneratorModifierProvider;
import com.teamabnormals.environmental.core.data.server.modifiers.EnvironmentalDataRemolderProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalBannerPatternTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalBiomeTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalBlockTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalEntityTypeTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalItemTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalPaintingVariantTagsProvider;
import com.teamabnormals.environmental.core.data.server.tags.EnvironmentalSlabfishTypeTagsProvider;
import com.teamabnormals.environmental.core.other.EnvironmentalArmorMaterials;
import com.teamabnormals.environmental.core.other.EnvironmentalClientCompat;
import com.teamabnormals.environmental.core.other.EnvironmentalCompat;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.EnvironmentalDataSerializers;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomeModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMemoryModuleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalMenuTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalPlacementModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.EnvironmentalSensorTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSlabfishConditions;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.core.registry.EnvironmentalTreeDecorators;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="environmental")
public class Environmental {
    public static final String MOD_ID = "environmental";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("environmental");

    public Environmental(IEventBus bus, ModContainer container) {
        EnvironmentalDataProcessors.registerTrackedData();
        EnvironmentalBlocks.BLOCKS.register(bus);
        EnvironmentalItems.ITEMS.register(bus);
        EnvironmentalEntityTypes.ENTITY_TYPES.register(bus);
        EnvironmentalSoundEvents.SOUND_EVENTS.register(bus);
        EnvironmentalFeatures.FEATURES.register(bus);
        EnvironmentalTreeDecorators.TREE_DECORATORS.register(bus);
        EnvironmentalMobEffects.MOB_EFFECTS.register(bus);
        EnvironmentalMenuTypes.MENUS.register(bus);
        EnvironmentalParticleTypes.PARTICLE_TYPES.register(bus);
        EnvironmentalSlabfishConditions.SLABFISH_CONDITIONS.register(bus);
        EnvironmentalDataSerializers.DATA_SERIALIZERS.register(bus);
        EnvironmentalPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        EnvironmentalBiomeModifierTypes.BIOME_MODIFIER_SERIALIZERS.register(bus);
        EnvironmentalMemoryModuleTypes.MEMORY_MODULE_TYPES.register(bus);
        EnvironmentalSensorTypes.SENSOR_TYPES.register(bus);
        EnvironmentalCriteriaTriggers.TRIGGERS.register(bus);
        EnvironmentalArmorMaterials.ARMOR_MATERIALS.register(bus);
        bus.addListener(this::registerCapabilities);
        bus.addListener(this::registerPayloadHandlers);
        bus.addListener(EnvironmentalRegistries::registerRegistries);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            SlabfishSpriteUploader.init(bus);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EnvironmentalConfig.COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EnvironmentalConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(EnvironmentalCompat::register);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(EnvironmentalClientCompat::register);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        EnvironmentalDatapackProvider datapackEntries = new EnvironmentalDatapackProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        EnvironmentalBlockTagsProvider blockTags = new EnvironmentalBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new EnvironmentalItemTagsProvider(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalSlabfishTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalRecipeProvider(output, provider));
        generator.addProvider(server, (DataProvider)EnvironmentalAdvancementProvider.create(output, provider, helper));
        generator.addProvider(server, (DataProvider)new EnvironmentalAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new EnvironmentalChunkGeneratorModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new EnvironmentalLootTableProvider(output, provider));
        generator.addProvider(server, (DataProvider)new EnvironmentalDataMapProvider(output, provider));
        generator.addProvider(server, (DataProvider)new EnvironmentalDataRemolderProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new EnvironmentalItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new EnvironmentalBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new EnvironmentalSpriteSourceProvider(output, provider, helper));
        generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper, provider));
    }

    private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(ZebraJumpPayload.TYPE, ZebraJumpPayload.STREAM_CODEC, ZebraJumpPayload::handle);
        registrar.playToClient(OpenSlabfishInventoryPayload.TYPE, OpenSlabfishInventoryPayload.STREAM_CODEC, OpenSlabfishInventoryPayload::handle);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)EnvironmentalEntityTypes.SLABFISH.get(), (entity, ctx) -> new InvWrapper((Container)entity.slabfishBackpack));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

