/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server;

import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishVariants;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class EnvironmentalAdvancementProvider
implements AdvancementProvider.AdvancementGenerator {
    public static AdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new AdvancementProvider(output, provider, helper, List.of(new EnvironmentalAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper helper) {
        EnvironmentalAdvancementProvider.createAdvancement("backpack_slabfish", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/tame_an_animal"), (ItemLike)Items.CHEST, AdvancementType.TASK, true, true, false).addCriterion("backpack_slabfish", EnvironmentalCriteriaTriggers.backpackSlabfish()).save(consumer, "environmental:husbandry/backpack_slabfish");
        EnvironmentalAdvancementProvider.createAdvancement("place_koi_in_village", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/tactical_fishing"), (ItemLike)EnvironmentalItems.KOI_BUCKET.get(), AdvancementType.TASK, true, true, false).addCriterion("place_koi_in_village", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setStructures((HolderSet)provider.lookupOrThrow(Registries.STRUCTURE).get(StructureTags.VILLAGE).get()), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{EnvironmentalItems.KOI_BUCKET}))).save(consumer, "environmental:husbandry/place_koi_in_village");
        AdvancementHolder saddlePig = EnvironmentalAdvancementProvider.createAdvancement("saddle_pig", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)Items.SADDLE, AdvancementType.TASK, true, true, false).addCriterion("saddle_pig", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SADDLE}), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(EntityType.PIG).build())))).save(consumer, "environmental:husbandry/saddle_pig");
        EnvironmentalAdvancementProvider.createAdvancement("when_pigs_fly", "husbandry", saddlePig, (ItemLike)Items.CARROT_ON_A_STICK, AdvancementType.CHALLENGE, true, true, false).addCriterion("when_pigs_fly", EnvironmentalCriteriaTriggers.whenPigsFly()).save(consumer, "environmental:husbandry/when_pigs_fly");
        AdvancementHolder throwMud = EnvironmentalAdvancementProvider.createAdvancement("throw_mud_at_pig", "husbandry", saddlePig, (ItemLike)EnvironmentalItems.MUD_BALL.get(), AdvancementType.TASK, true, true, false).addCriterion("throw_mud_at_pig", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntity((DamagePredicate.Builder)DamagePredicate.Builder.damageInstance().type(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of((EntityType)EnvironmentalEntityTypes.MUD_BALL.get()))), Optional.of(EntityPredicate.Builder.entity().of(EntityType.PIG).build()))).save(consumer, "environmental:husbandry/throw_mud_at_pig");
        EnvironmentalAdvancementProvider.createAdvancement("plant_on_muddy_pig", "husbandry", throwMud, (ItemLike)Items.RED_TULIP, AdvancementType.TASK, true, true, false).addCriterion("plant_on_muddy_pig", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(EnvironmentalItemTags.MUDDY_PIG_DECORATIONS), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(EntityType.PIG).build())))).save(consumer, "environmental:husbandry/plant_on_muddy_pig");
        AdvancementHolder feedPig = EnvironmentalAdvancementProvider.createAdvancement("truffle_shuffle", "husbandry", saddlePig, (ItemLike)Items.GOLDEN_CARROT, AdvancementType.TASK, true, true, false).addCriterion("truffle_shuffle", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.GOLDEN_CARROT}), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(EntityType.PIG).build())))).save(consumer, "environmental:husbandry/truffle_shuffle");
        EnvironmentalAdvancementProvider.createAdvancement("find_truffle", "husbandry", feedPig, (ItemLike)EnvironmentalItems.TRUFFLE.get(), AdvancementType.TASK, true, true, false).addCriterion("find_truffle", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)EnvironmentalItems.TRUFFLE.get()})).save(consumer, "environmental:husbandry/find_truffle");
        EnvironmentalAdvancementProvider.createAdvancement("shear_yak_with_pants", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)EnvironmentalItems.YAK_PANTS.get(), AdvancementType.TASK, true, true, false).addCriterion("shear_yak_with_pants", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity(Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().legs(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)EnvironmentalItems.YAK_PANTS.get()})).build()).build())), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of((EntityType)EnvironmentalEntityTypes.YAK.get()).build())))).save(consumer, "environmental:husbandry/shear_yak_with_pants");
        EnvironmentalAdvancementProvider.createAdvancement("shear_cattail", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)EnvironmentalItems.CATTAIL_FLUFF.get(), AdvancementType.TASK, true, true, false).addCriterion("shear_cattail", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)EnvironmentalBlocks.CATTAIL.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR))).save(consumer, "environmental:husbandry/shear_cattail");
        EnvironmentalAdvancementProvider.createAdvancement("feed_deer_flower", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)Items.APPLE, AdvancementType.TASK, true, true, false).addCriterion("feed_deer_flower", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(EnvironmentalItemTags.DEER_PLANTABLES), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(EnvironmentalEntityTypeTags.DEER).build())))).save(consumer, "environmental:husbandry/feed_deer_flower");
        Advancement.Builder tameSlabfish = EnvironmentalAdvancementProvider.createAdvancement("tame_all_slabfish", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/tame_an_animal"), (ItemLike)Items.TROPICAL_FISH, AdvancementType.CHALLENGE, true, true, false);
        for (ResourceKey slabfish : ((HolderLookup.RegistryLookup)provider.lookup(EnvironmentalRegistries.SLABFISH_VARIANT).get()).listElementIds().filter(key -> !EnvironmentalSlabfishVariants.COMPAT_SLABFISH.contains(key)).sorted().toList()) {
            tameSlabfish.addCriterion(slabfish.location().toString(), EnvironmentalAdvancementProvider.slabfishCriterion((ResourceKey<SlabfishVariant>)slabfish));
        }
        tameSlabfish.save(consumer, "environmental:husbandry/tame_all_slabfish");
    }

    public static Criterion<TameAnimalTrigger.TriggerInstance> slabfishCriterion(ResourceKey<SlabfishVariant> slabfish) {
        CompoundTag tag = new CompoundTag();
        tag.putString("SlabfishVariant", slabfish.location().toString());
        return TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)EnvironmentalEntityTypes.SLABFISH.get()).nbt(new NbtPredicate(tag)));
    }

    private static Advancement.Builder createAdvancement(String name, String category, AdvancementHolder parent, ItemLike icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.advancement().parent(parent).display(icon, (Component)Component.translatable((String)("advancements.environmental." + category + "." + name + ".title")), (Component)Component.translatable((String)("advancements.environmental." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemLike icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return EnvironmentalAdvancementProvider.createAdvancement(name, category, Advancement.Builder.advancement().build(parent), icon, frame, showToast, announceToChat, hidden);
    }
}

