/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.data.server.EnvironmentalAdvancementProvider;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalBiomes;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishVariants;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.FilledBucketTrigger;
import net.minecraft.advancements.critereon.FishingRodHookedTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EnvironmentalAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[]{(EntityType)EnvironmentalEntityTypes.SLABFISH.get(), (EntityType)EnvironmentalEntityTypes.DUCK.get(), (EntityType)EnvironmentalEntityTypes.DEER.get(), (EntityType)EnvironmentalEntityTypes.REINDEER.get(), (EntityType)EnvironmentalEntityTypes.YAK.get(), (EntityType)EnvironmentalEntityTypes.TAPIR.get(), (EntityType)EnvironmentalEntityTypes.ZEBRA.get()};

    public EnvironmentalAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("environmental", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, (MobEffectsPredicate)MobEffectsPredicate.Builder.effects().and(MobEffects.HEALTH_BOOST).and(EnvironmentalMobEffects.SERENITY).build().get()), new ICondition[0]);
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, (MobEffectsPredicate)MobEffectsPredicate.Builder.effects().and(MobEffects.HEALTH_BOOST).build().get()), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        List<DeferredHolder> items = ((DeferredRegister.Items)EnvironmentalItems.ITEMS.getDeferredRegister()).getEntries().stream().filter(i -> ((Item)i.get()).getDefaultInstance().getFoodProperties(null) != null).toList();
        items.forEach(item -> balancedDiet.addCriterion(BuiltInRegistries.ITEM.getKey((Object)((Item)item.get())).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)item.get()))));
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAllAnimals = CriteriaModifier.builder((String)this.modId);
        for (EntityType<?> entityType : BREEDABLE_ANIMALS) {
            breedAllAnimals.addCriterion(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath(), BredAnimalsTrigger.TriggerInstance.bredAnimals((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType)));
        }
        this.entry("husbandry/bred_all_animals").selects(new String[]{"husbandry/bred_all_animals"}).addModifier((ObjectModifier)breedAllAnimals.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        this.entry("husbandry/whole_pack").selects(new String[]{"husbandry/whole_pack"}).addModifier((ObjectModifier)this.addTamedWolfVariants(provider).requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        CriteriaModifier.Builder adventuringTime = CriteriaModifier.builder((String)this.modId);
        HolderLookup.RegistryLookup biomes = provider.lookupOrThrow(Registries.BIOME);
        EnvironmentalBiomes.NATURAL_BIOMES.forEach(biome -> adventuringTime.addCriterion(biome.location().toString(), PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)biomes.getOrThrow(biome)))));
        this.entry("adventure/adventuring_time").selects(new String[]{"adventure/adventuring_time"}).addModifier((ObjectModifier)adventuringTime.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        this.entry("husbandry/fishy_business").selects(new String[]{"husbandry/fishy_business"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("koi", FishingRodHookedTrigger.TriggerInstance.fishedItem(Optional.empty(), Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)EnvironmentalItems.KOI.get()}).build()))).addIndexedRequirements(0, false, new String[]{"koi"}).build(), new ICondition[0]);
        this.entry("husbandry/tactical_fishing").selects(new String[]{"husbandry/tactical_fishing"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("koi_bucket", FilledBucketTrigger.TriggerInstance.filledBucket((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)EnvironmentalItems.KOI_BUCKET.get()}))).addCriterion("slabfish_bucket", FilledBucketTrigger.TriggerInstance.filledBucket((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)EnvironmentalItems.SLABFISH_BUCKET.get()}))).addIndexedRequirements(0, false, new String[]{"koi_bucket", "slabfish_bucket"}).build(), new ICondition[0]);
        this.entry("husbandry/plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("cattail_sprouts", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)((Block)EnvironmentalBlocks.CATTAIL_SPROUT.get()))).addIndexedRequirements(0, false, new String[]{"cattail_sprouts"}).build(), new ICondition[0]);
        this.compatSlabfishModifier("atmospheric", EnvironmentalSlabfishVariants.ATMOSPHERIC_SLABFISH);
        this.compatSlabfishModifier("autumnity", EnvironmentalSlabfishVariants.AUTUMNITY_SLABFISH);
        this.compatSlabfishModifier("endergetic", EnvironmentalSlabfishVariants.ENDERGETIC_SLABFISH);
    }

    public void compatSlabfishModifier(String modid, List<ResourceKey<SlabfishVariant>> slabfishTypes) {
        ConditionedResourceSelector selector = new ConditionedResourceSelector((ResourceSelector)new NamesResourceSelector(new ResourceLocation[]{Environmental.location("husbandry/tame_all_slabfish")}), new ICondition[]{new ModLoadedCondition(modid)});
        CriteriaModifier.Builder tameAllSlabfish = CriteriaModifier.builder((String)this.modId);
        slabfishTypes.forEach(slabfish -> tameAllSlabfish.addCriterion(slabfish.location().getPath(), EnvironmentalAdvancementProvider.slabfishCriterion((ResourceKey<SlabfishVariant>)slabfish)));
        this.entry("husbandry/tame_all_slabfish_" + modid).selector(selector).addModifier((ObjectModifier)tameAllSlabfish.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
    }

    private CriteriaModifier.Builder addTamedWolfVariants(HolderLookup.Provider registries) {
        CriteriaModifier.Builder builder = CriteriaModifier.builder((String)this.modId);
        HolderLookup.RegistryLookup registrylookup = registries.lookupOrThrow(Registries.WOLF_VARIANT);
        registrylookup.listElementIds().filter(key -> key.location().getNamespace().equals("environmental")).sorted(Comparator.comparing(ResourceKey::location)).forEach(variant -> {
            Holder.Reference holder = registrylookup.getOrThrow(variant);
            builder.addCriterion(variant.location().toString(), TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate(EntitySubPredicates.wolfVariant((HolderSet)HolderSet.direct((Holder[])new Holder[]{holder})))));
        });
        return builder;
    }
}

