/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.mixin;

import com.teamabnormals.environmental.common.entity.animal.PineconeGolem;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarvedPumpkinBlock.class})
public final class CarvedPumpkinBlockMixin {
    @Inject(method={"canSpawnGolem"}, at={@At(value="RETURN")}, cancellable=true)
    private void canSpawnGolem(LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (level.getBlockState(pos.below()).is(EnvironmentalBlockTags.PINECONE_GOLEM_BASE_BLOCKS) && ((Boolean)EnvironmentalConfig.COMMON.pineconeGolems.get()).booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"trySpawnGolem"}, at={@At(value="HEAD")}, cancellable=true)
    private void trySpawnGolem(Level level, BlockPos pos, CallbackInfo ci) {
        BlockPos belowpos = pos.below();
        BlockState belowstate = level.getBlockState(pos.below());
        if (belowstate.is(EnvironmentalBlockTags.PINECONE_GOLEM_BASE_BLOCKS) && ((Boolean)EnvironmentalConfig.COMMON.pineconeGolems.get()).booleanValue()) {
            BlockState state = level.getBlockState(pos);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            level.setBlock(belowpos, Blocks.AIR.defaultBlockState(), 2);
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
            level.levelEvent(2001, belowpos, Block.getId((BlockState)belowstate));
            PineconeGolem pineconegolem = (PineconeGolem)((EntityType)EnvironmentalEntityTypes.PINECONE_GOLEM.get()).create(level);
            float yRot = ((Direction)state.getValue((Property)CarvedPumpkinBlock.FACING)).toYRot();
            pineconegolem.moveTo((double)belowpos.getX() + 0.5, (double)belowpos.getY() + 0.05, (double)belowpos.getZ() + 0.5);
            pineconegolem.yHeadRot = yRot;
            pineconegolem.yBodyRot = yRot;
            level.addFreshEntity((Entity)pineconegolem);
            for (ServerPlayer serverplayer : level.getEntitiesOfClass(ServerPlayer.class, pineconegolem.getBoundingBox().inflate(5.0))) {
                CriteriaTriggers.SUMMONED_ENTITY.trigger(serverplayer, (Entity)pineconegolem);
            }
            level.blockUpdated(pos, Blocks.AIR);
            level.blockUpdated(belowpos, Blocks.AIR);
            ci.cancel();
        }
    }
}

