/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.mixin;

import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebra;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Horse.class})
public abstract class HorseMixin
extends AbstractHorse {
    @Shadow
    public abstract Variant getVariant();

    @Shadow
    public abstract Markings getMarkings();

    protected HorseMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"canMate"}, at={@At(value="HEAD")}, cancellable=true)
    public void canMate(Animal otherParent, CallbackInfoReturnable<Boolean> cir) {
        if (otherParent instanceof Zebra && this.canParent() && ((AbstractHorse)otherParent).canParent()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getBreedOffspring"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBreedOffspring(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<AgeableMob> cir) {
        if (otherParent instanceof Zebra) {
            Zebra zebra = (Zebra)otherParent;
            Zorse zorse = (Zorse)((EntityType)EnvironmentalEntityTypes.ZORSE.get()).create((Level)level);
            if (zorse != null) {
                int i = this.random.nextInt(9);
                Variant variant = i < 8 ? this.getVariant() : (Variant)Util.getRandom((Object[])Variant.values(), (RandomSource)this.random);
                int j = this.random.nextInt(5);
                Markings markings = j < 2 ? Markings.NONE : (j < 4 ? this.getMarkings() : (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.random));
                zorse.setVariantAndMarkings(variant, markings);
                zorse.randomizeStripeOpacity(level.getRandom());
                zebra.setOffspringAttributes((AgeableMob)this, zorse);
            }
            cir.setReturnValue((Object)zorse);
        }
    }
}

