/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.environmental.common.entity.ai.goal.CatLeapAtDwarfSpruceGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.HuntTruffleGoal;
import com.teamabnormals.environmental.common.entity.animal.koi.Koi;
import com.teamabnormals.environmental.common.entity.animal.slabfish.Slabfish;
import com.teamabnormals.environmental.common.entity.animal.slabfish.SlabfishOverlay;
import com.teamabnormals.environmental.common.slabfish.SlabfishHelper;
import com.teamabnormals.environmental.common.slabfish.SlabfishVariant;
import com.teamabnormals.environmental.core.EnvironmentalConfig;
import com.teamabnormals.environmental.core.other.EnvironmentalCriteriaTriggers;
import com.teamabnormals.environmental.core.other.EnvironmentalDataProcessors;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBlockTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalEntityTypeTags;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalItemTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalItems;
import com.teamabnormals.environmental.core.registry.EnvironmentalMobEffects;
import com.teamabnormals.environmental.core.registry.EnvironmentalParticleTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalSoundEvents;
import com.teamabnormals.environmental.core.registry.datapack.slabfish.EnvironmentalSlabfishVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="environmental")
public class EnvironmentalEvents {
    public static final List<MobSpawnType> VALID_SPAWNS = List.of(MobSpawnType.NATURAL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.JOCKEY, MobSpawnType.REINFORCEMENT, MobSpawnType.PATROL);
    protected static final Set<Block> DIRT_SPREADABLES = Sets.newHashSet((Object[])new Block[]{Blocks.GRASS_BLOCK, Blocks.MYCELIUM});

    @SubscribeEvent
    public static void onLivingSpawn(FinalizeSpawnEvent event) {
        boolean spawner;
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        boolean natural = VALID_SPAWNS.contains(event.getSpawnType());
        boolean bl = spawner = (Boolean)EnvironmentalConfig.COMMON.blockOnlyNaturalSpawns.get() == false && event.getSpawnType() == MobSpawnType.SPAWNER;
        if ((natural || spawner) && entity.getType().getCategory() == MobCategory.MONSTER && !entity.getType().is(EnvironmentalEntityTypeTags.UNAFFECTED_BY_SERENITY)) {
            int horizontalRange = (Integer)EnvironmentalConfig.COMMON.koiHorizontalSerenityRange.get();
            int verticalRange = (Integer)EnvironmentalConfig.COMMON.koiVerticalSerenityRange.get();
            for (Koi koi : level.getEntitiesOfClass(Koi.class, entity.getBoundingBox().inflate((double)horizontalRange, (double)verticalRange, (double)horizontalRange))) {
                if (!(MathUtil.distanceBetweenPoints2d((double)entity.getX(), (double)entity.getZ(), (double)koi.getX(), (double)koi.getZ()) <= (double)horizontalRange)) continue;
                event.setSpawnCancelled(true);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onEndermanPlaceBlock(EntityMobGriefingEvent event) {
        EnderMan enderman;
        Entity entity = event.getEntity();
        if (entity instanceof EnderMan && (enderman = (EnderMan)entity).hasEffect(EnvironmentalMobEffects.SERENITY)) {
            event.setCanGrief(false);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Optional potion;
        ThrownPotion thrownPotion;
        ItemStack itemstack;
        Entity contents;
        Entity entity = event.getEntity();
        if (entity instanceof ThrownPotion && (contents = (PotionContents)(itemstack = (thrownPotion = (ThrownPotion)entity).getItem()).get(DataComponents.POTION_CONTENTS)) != null && (potion = contents.potion()).isPresent() && ((Holder)potion.get()).is(Potions.WATER) && contents.customEffects().isEmpty()) {
            AABB axisalignedbb = thrownPotion.getBoundingBox().inflate(2.0, 1.0, 2.0);
            List slabs = thrownPotion.level().getEntitiesOfClass(Slabfish.class, axisalignedbb);
            if (!slabs.isEmpty()) {
                for (Slabfish slabfish : slabs) {
                    slabfish.setOverlay(null);
                }
            }
        }
        if ((contents = event.getEntity()) instanceof ThrowableItemProjectile) {
            EntityHitResult entity2;
            ThrowableItemProjectile projectile = (ThrowableItemProjectile)contents;
            contents = event.getRayTraceResult();
            if (contents instanceof EntityHitResult && (potion = (entity2 = (EntityHitResult)contents).getEntity()) instanceof Slabfish) {
                Slabfish slabfish = (Slabfish)((Object)potion);
                ItemStack stack = projectile.getItem();
                Optional<Holder.Reference<SlabfishOverlay>> overlay = SlabfishOverlay.getOverlayForItem(slabfish.registryAccess(), stack);
                if (!(!overlay.isPresent() || slabfish.getOverlay().isPresent() && slabfish.getOverlay().get().is((Holder)overlay.get()))) {
                    slabfish.setOverlay((Holder<SlabfishOverlay>)((Holder)overlay.get()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Direction face = event.getFace();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (stack.canPerformAction(ItemAbilities.SHOVEL_DIG) && !player.isSpectator() && state.is((Block)EnvironmentalBlocks.BURIED_TRUFFLE.get())) {
            level.playSound(player, pos, (SoundEvent)EnvironmentalSoundEvents.SHOVEL_DIG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                Vec3i vector3i = face.getNormal();
                double d0 = (double)pos.getX() + 0.5 + 0.625 * (double)vector3i.getX();
                double d1 = (double)pos.getY() + 0.375 + 0.625 * (double)vector3i.getY();
                double d2 = (double)pos.getZ() + 0.5 + 0.625 * (double)vector3i.getZ();
                ItemEntity itementity = new ItemEntity(level, d0, d1, d2, new ItemStack((ItemLike)EnvironmentalItems.TRUFFLE.get(), 1));
                level.addFreshEntity((Entity)itementity);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 11);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        } else if (stack.canPerformAction(ItemAbilities.HOE_TILL) && state.is((Block)EnvironmentalBlocks.DIRT_PATH.get()) && !player.isSpectator() && level.isEmptyBlock(pos.above())) {
            level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                level.setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 11);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        } else if (event.getFace() != Direction.DOWN && stack.canPerformAction(ItemAbilities.SHOVEL_FLATTEN) && !player.isSpectator() && level.isEmptyBlock(pos.above()) && (state.is(Blocks.PODZOL) || state.is(Blocks.MYCELIUM) || state.is(Blocks.DIRT) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.ROOTED_DIRT))) {
            level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                level.setBlock(pos, state.is(Blocks.PODZOL) ? ((Block)EnvironmentalBlocks.PODZOL_PATH.get()).defaultBlockState() : (state.is(Blocks.MYCELIUM) ? ((Block)EnvironmentalBlocks.MYCELIUM_PATH.get()).defaultBlockState() : ((Block)EnvironmentalBlocks.DIRT_PATH.get()).defaultBlockState()), 11);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        Level level = event.getLevel();
        RandomSource random = level.getRandom();
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            if (target instanceof Bucketable && stack.is(Items.WATER_BUCKET) && target.isAlive()) {
                mob.dropLeash(true, true);
            }
        }
        if (target instanceof Pig) {
            Pig pig = (Pig)target;
            if (target.isAlive()) {
                IDataManager data = (IDataManager)target;
                if (!pig.isLeashed() && stack.is(EnvironmentalItemTags.PIG_TRUFFLE_ITEMS) && !pig.isBaby() && ((Boolean)EnvironmentalConfig.COMMON.pigsHuntTruffles.get()).booleanValue() && (Integer)data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME) == 0) {
                    if (level.dimensionType().natural()) {
                        data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)4800);
                        if (!event.getEntity().isCreative()) {
                            stack.shrink(1);
                        }
                        if (level.isClientSide()) {
                            for (int i = 0; i < 7; ++i) {
                                double d0 = random.nextGaussian() * 0.02;
                                double d1 = random.nextGaussian() * 0.02;
                                double d2 = random.nextGaussian() * 0.02;
                                level.addParticle((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), target.getRandomX(1.0), target.getRandomY() + 0.5, target.getRandomZ(1.0), d0, d1, d2);
                            }
                        }
                    } else if (level.isClientSide()) {
                        for (int i = 0; i < 7; ++i) {
                            double d0 = random.nextGaussian() * 0.02;
                            double d1 = random.nextGaussian() * 0.02;
                            double d2 = random.nextGaussian() * 0.02;
                            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, target.getRandomX(1.0), target.getRandomY() + 0.5, target.getRandomZ(1.0), d0, d1, d2);
                        }
                    }
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity;
        Pig pig;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof Pig && (pig = (Pig)livingEntity2).hasControllingPassenger() && event.getDistance() > 3.75f && (livingEntity = pig.getControllingPassenger()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ((PlayerTrigger)EnvironmentalCriteriaTriggers.WHEN_PIGS_FLY.get()).trigger(player);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.getCommandSenderWorld();
        RandomSource rand = RandomSource.create();
        if (entity instanceof Slabfish) {
            Slabfish slabfish = (Slabfish)entity;
            if (world.getBiome(entity.blockPosition()).is(Biomes.SOUL_SAND_VALLEY) && !slabfish.getVariant().is(EnvironmentalSlabfishVariants.GHOST)) {
                if (world.isClientSide()) {
                    for (int i = 0; i < 7; ++i) {
                        double d0 = rand.nextGaussian() * 0.02;
                        double d1 = rand.nextGaussian() * 0.02;
                        double d2 = rand.nextGaussian() * 0.02;
                        world.addParticle((ParticleOptions)ParticleTypes.SOUL, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
                    }
                }
                if (!world.isClientSide()) {
                    Slabfish ghost = (Slabfish)((EntityType)EnvironmentalEntityTypes.SLABFISH.get()).create(world);
                    if (ghost == null) {
                        return;
                    }
                    ghost.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 140, 0, false, false));
                    ghost.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 140, 0, false, false));
                    world.playSound(null, entity.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ghost.moveTo(slabfish.getX(), slabfish.getY(), slabfish.getZ(), slabfish.getYRot(), slabfish.getXRot());
                    ghost.setNoAi(slabfish.isNoAi());
                    ghost.setAge(slabfish.getAge());
                    ghost.setVariant((Holder<SlabfishVariant>)SlabfishHelper.slabfishTypes(slabfish.registryAccess()).getHolderOrThrow(EnvironmentalSlabfishVariants.GHOST));
                    ghost.extinguishFire();
                    if (slabfish.hasCustomName()) {
                        ghost.setCustomName(entity.getCustomName());
                        ghost.setCustomNameVisible(entity.isCustomNameVisible());
                    }
                    world.addFreshEntity((Entity)ghost);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBabySpawn(BabyEntitySpawnEvent event) {
        Pig baby;
        int i;
        int piglets;
        int minBonus;
        Mob level;
        Mob mob = event.getParentA();
        if (mob instanceof Pig) {
            Pig pig = (Pig)mob;
            if (event.getParentB() instanceof Pig && ((Boolean)EnvironmentalConfig.COMMON.largerPigLitters.get()).booleanValue()) {
                level = pig.level();
                minBonus = (Integer)EnvironmentalConfig.COMMON.minimumAdditionalPiglets.get();
                piglets = minBonus + level.random.nextInt((Integer)EnvironmentalConfig.COMMON.maximumAdditionalPiglets.get() + 1 - minBonus);
                for (i = 0; i < piglets; ++i) {
                    baby = (Pig)EntityType.PIG.create((Level)level);
                    if (baby == null) continue;
                    baby.setBaby(true);
                    baby.moveTo(pig.getX(), pig.getY(), pig.getZ(), 0.0f, 0.0f);
                    level.addFreshEntity((Entity)baby);
                }
            }
        }
        if ((level = event.getParentA()) instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)level;
            if (event.getParentB() instanceof Hoglin && ((Boolean)EnvironmentalConfig.COMMON.largerHoglinLitters.get()).booleanValue()) {
                level = hoglin.level();
                minBonus = (Integer)EnvironmentalConfig.COMMON.minimumAdditionalHoglets.get();
                piglets = minBonus + level.random.nextInt((Integer)EnvironmentalConfig.COMMON.maximumAdditionalHoglets.get() + 1 - minBonus);
                for (i = 0; i < piglets; ++i) {
                    baby = (Hoglin)EntityType.HOGLIN.create((Level)level);
                    if (baby == null) continue;
                    baby.setBaby(true);
                    baby.moveTo(hoglin.getX(), hoglin.getY(), hoglin.getZ(), 0.0f, 0.0f);
                    level.addFreshEntity((Entity)baby);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.targetSelector.addGoal(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)wolf, Animal.class, false, target -> {
                EntityType type = target.getType();
                return type == EnvironmentalEntityTypes.DEER.get() || type == EnvironmentalEntityTypes.TAPIR.get() || type == EnvironmentalEntityTypes.REINDEER.get();
            }));
        }
        if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Animal.class, 10, false, false, targetEntity -> targetEntity.getType() == EnvironmentalEntityTypes.DUCK.get()));
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.targetSelector.addGoal(8, (Goal)new CatLeapAtDwarfSpruceGoal(cat));
        }
        if (entity instanceof Pig) {
            Set goals;
            Pig pig = (Pig)entity;
            if (((Boolean)EnvironmentalConfig.COMMON.pigsHuntTruffles.get()).booleanValue() && (goals = pig.goalSelector.getAvailableGoals()).stream().noneMatch(goal -> goal.getGoal() instanceof HuntTruffleGoal)) {
                pig.goalSelector.addGoal(2, (Goal)new HuntTruffleGoal(pig));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.getCommandSenderWorld();
        RandomSource random = level.getRandom();
        if (entity instanceof Pig && entity.isAlive()) {
            IDataManager data = (IDataManager)entity;
            int huntingtime = (Integer)data.getValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME);
            BlockPos trufflepos = (BlockPos)data.getValue(EnvironmentalDataProcessors.TRUFFLE_POS);
            if (huntingtime == 0 || ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && level.getBlockState(trufflepos).getBlock() != EnvironmentalBlocks.BURIED_TRUFFLE.get()) {
                data.setValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET, (Object)false);
                if (huntingtime > 0) {
                    data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)Math.max(-400, -huntingtime));
                }
            } else if (huntingtime > 0) {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime - 1));
            } else {
                data.setValue(EnvironmentalDataProcessors.TRUFFLE_HUNTING_TIME, (Object)(huntingtime + 1));
                if (level.isClientSide() && ((Boolean)data.getValue(EnvironmentalDataProcessors.HAS_TRUFFLE_TARGET)).booleanValue() && huntingtime % 10 == 0) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    level.addParticle((ParticleOptions)EnvironmentalParticleTypes.PIG_FINDS_TRUFFLE.get(), entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
                }
            }
            int sniffsoundtime = (Integer)data.getValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME);
            data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)(sniffsoundtime + 1));
            if (!level.isClientSide() && ((Boolean)data.getValue(EnvironmentalDataProcessors.LOOKING_FOR_TRUFFLE)).booleanValue() && random.nextInt(60) < sniffsoundtime) {
                entity.playSound((SoundEvent)EnvironmentalSoundEvents.PIG_SNIFF.get(), 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                data.setValue(EnvironmentalDataProcessors.SNIFF_SOUND_TIME, (Object)-20);
            }
        }
    }

    @SubscribeEvent
    public static void onBonemeal(BonemealEvent event) {
        Level level = event.getLevel();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        RandomSource random = level.getRandom();
        if (((Boolean)EnvironmentalConfig.COMMON.cactusBobble.get()).booleanValue() && state.is(EnvironmentalBlockTags.CACTUS_BOBBLE_PLANTABLE_ON) && level.getBlockState(pos.above()).isAir()) {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos.above(), ((Block)EnvironmentalBlocks.CACTUS_BOBBLE.get()).defaultBlockState());
            }
            event.setSuccessful(true);
            event.setCanceled(true);
        }
        if (state.is(Blocks.DIRT) && level.getBlockState(pos.above()).propagatesSkylightDown((BlockGetter)level, pos)) {
            ArrayList<BlockState> potentialStates = new ArrayList<BlockState>();
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                Block block = level.getBlockState(blockpos).getBlock();
                if (!DIRT_SPREADABLES.contains(block) || potentialStates.contains(block.defaultBlockState())) continue;
                potentialStates.add(block.defaultBlockState());
            }
            if (!potentialStates.isEmpty()) {
                if (!level.isClientSide()) {
                    level.setBlock(pos, (BlockState)potentialStates.get(level.getRandom().nextInt(potentialStates.size())), 3);
                }
                event.setSuccessful(true);
                event.setCanceled(true);
            }
        }
        if (state.is(Blocks.MYCELIUM) && level.getBlockState(pos.above()).isAir()) {
            if (!level.isClientSide()) {
                BlockPos abovePos = pos.above();
                for (int i = 0; i < 128; ++i) {
                    BlockPos newPos = abovePos;
                    for (int j = 0; j < i / 16 && level.getBlockState((newPos = newPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is(Blocks.MYCELIUM) && !level.getBlockState(newPos).isCollisionShapeFullBlock((BlockGetter)level, newPos); ++j) {
                    }
                    if (!level.getBlockState(newPos).isAir() || !((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()).defaultBlockState().canSurvive((LevelReader)level, newPos)) continue;
                    level.setBlock(newPos, ((Block)EnvironmentalBlocks.MYCELIUM_SPROUTS.get()).defaultBlockState(), 3);
                }
            }
            event.setSuccessful(true);
            event.setCanceled(true);
        }
        if (state.is(Blocks.TALL_GRASS)) {
            if (!level.isClientSide()) {
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)((Block)EnvironmentalBlocks.GIANT_TALL_GRASS.get()).defaultBlockState(), (BlockPos)(state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER ? pos : pos.below()), (int)2);
            }
            event.setSuccessful(true);
            event.setCanceled(true);
        }
    }
}

