/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.other;

import com.teamabnormals.environmental.client.model.DeerModel;
import com.teamabnormals.environmental.client.model.DuckModel;
import com.teamabnormals.environmental.client.model.KoiModel;
import com.teamabnormals.environmental.client.model.MuleArmorModel;
import com.teamabnormals.environmental.client.model.PineconeGolemModel;
import com.teamabnormals.environmental.client.model.ReindeerModel;
import com.teamabnormals.environmental.client.model.SlabfishModel;
import com.teamabnormals.environmental.client.model.TapirModel;
import com.teamabnormals.environmental.client.model.YakModel;
import com.teamabnormals.environmental.client.model.ZebraModel;
import com.teamabnormals.environmental.client.model.ZonkeyModel;
import com.teamabnormals.environmental.client.model.ZorseModel;
import com.teamabnormals.environmental.client.renderer.entity.DeerRenderer;
import com.teamabnormals.environmental.client.renderer.entity.DuckRenderer;
import com.teamabnormals.environmental.client.renderer.entity.KoiRenderer;
import com.teamabnormals.environmental.client.renderer.entity.PineconeGolemRenderer;
import com.teamabnormals.environmental.client.renderer.entity.ReindeerRenderer;
import com.teamabnormals.environmental.client.renderer.entity.SlabfishRenderer;
import com.teamabnormals.environmental.client.renderer.entity.TapirRenderer;
import com.teamabnormals.environmental.client.renderer.entity.YakRenderer;
import com.teamabnormals.environmental.client.renderer.entity.ZebraRenderer;
import com.teamabnormals.environmental.client.renderer.entity.ZonkeyRenderer;
import com.teamabnormals.environmental.client.renderer.entity.ZorseRenderer;
import com.teamabnormals.environmental.client.renderer.entity.layers.MuddyPigDecorationLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.MuddyPigMudLayer;
import com.teamabnormals.environmental.client.renderer.entity.layers.MuleArmorLayer;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ChestedHorseRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="environmental", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EnvironmentalModelLayers {
    public static final ModelLayerLocation DEER = EnvironmentalModelLayers.register("deer");
    public static final ModelLayerLocation REINDEER = EnvironmentalModelLayers.register("reindeer");
    public static final ModelLayerLocation DUCK = EnvironmentalModelLayers.register("duck");
    public static final ModelLayerLocation KOI = EnvironmentalModelLayers.register("koi");
    public static final ModelLayerLocation SLABFISH = EnvironmentalModelLayers.register("slabfish");
    public static final ModelLayerLocation TAPIR = EnvironmentalModelLayers.register("tapir");
    public static final ModelLayerLocation YAK = EnvironmentalModelLayers.register("yak");
    public static final ModelLayerLocation ZEBRA = EnvironmentalModelLayers.register("zebra");
    public static final ModelLayerLocation ZORSE = EnvironmentalModelLayers.register("zorse");
    public static final ModelLayerLocation ZONKEY = EnvironmentalModelLayers.register("zonkey");
    public static final ModelLayerLocation ZORSE_ARMOR = EnvironmentalModelLayers.register("zorse_armor");
    public static final ModelLayerLocation MULE_ARMOR = EnvironmentalModelLayers.register("mule_armor");
    public static final ModelLayerLocation PINECONE_GOLEM = EnvironmentalModelLayers.register("pinecone_golem");

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.AddLayers event) {
        PigRenderer pigRenderer;
        ChestedHorseRenderer muleRenderer = (ChestedHorseRenderer)event.getRenderer(EntityType.MULE);
        if (muleRenderer != null) {
            muleRenderer.addLayer(new MuleArmorLayer(muleRenderer, event.getEntityModels()));
        }
        if ((pigRenderer = (PigRenderer)event.getRenderer(EntityType.PIG)) != null) {
            pigRenderer.addLayer(new MuddyPigMudLayer(pigRenderer));
            pigRenderer.addLayer(new MuddyPigDecorationLayer(pigRenderer, event.getContext().getBlockRenderDispatcher()));
        }
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DUCK, DuckModel::createBodyLayer);
        event.registerLayerDefinition(DEER, DeerModel::createBodyLayer);
        event.registerLayerDefinition(REINDEER, ReindeerModel::createBodyLayer);
        event.registerLayerDefinition(KOI, KoiModel::createBodyLayer);
        event.registerLayerDefinition(SLABFISH, SlabfishModel::createBodyLayer);
        event.registerLayerDefinition(YAK, YakModel::createBodyLayer);
        event.registerLayerDefinition(TAPIR, TapirModel::createBodyLayer);
        event.registerLayerDefinition(ZEBRA, () -> LayerDefinition.create((MeshDefinition)ZebraModel.createBodyMesh(CubeDeformation.NONE), (int)64, (int)64));
        event.registerLayerDefinition(ZORSE, () -> LayerDefinition.create((MeshDefinition)ZorseModel.createBodyMesh(CubeDeformation.NONE), (int)64, (int)64));
        event.registerLayerDefinition(ZONKEY, () -> LayerDefinition.create((MeshDefinition)ZonkeyModel.createBodyMesh(CubeDeformation.NONE), (int)64, (int)64));
        event.registerLayerDefinition(ZORSE_ARMOR, () -> LayerDefinition.create((MeshDefinition)ZorseModel.createBodyMesh(new CubeDeformation(0.1f)), (int)64, (int)64));
        event.registerLayerDefinition(MULE_ARMOR, () -> MuleArmorModel.createBodyLayer(new CubeDeformation(0.1f)));
        event.registerLayerDefinition(PINECONE_GOLEM, PineconeGolemModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), SlabfishRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.DUCK.get(), DuckRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.DEER.get(), DeerRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.REINDEER.get(), ReindeerRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.YAK.get(), YakRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.KOI.get(), KoiRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.TAPIR.get(), TapirRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.ZEBRA.get(), ZebraRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.ZORSE.get(), ZorseRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.ZONKEY.get(), ZonkeyRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.PINECONE_GOLEM.get(), PineconeGolemRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.DUCK_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)EnvironmentalEntityTypes.MUD_BALL.get(), ThrownItemRenderer::new);
    }

    public static ModelLayerLocation register(String name) {
        return EnvironmentalModelLayers.register(name, "main");
    }

    public static ModelLayerLocation register(String name, String layer) {
        return new ModelLayerLocation(Environmental.location(name), layer);
    }
}

