/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.item.BlueprintBoatItem;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import com.teamabnormals.environmental.common.item.DuckEggItem;
import com.teamabnormals.environmental.common.item.HibiscusBlockItem;
import com.teamabnormals.environmental.common.item.KoiBucketItem;
import com.teamabnormals.environmental.common.item.MudBallItem;
import com.teamabnormals.environmental.common.item.SlabfishBucketItem;
import com.teamabnormals.environmental.common.item.YakPantsItem;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalArmorMaterials;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBannerPatternTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalJukeboxSongs;
import com.teamabnormals.environmental.integration.boatload.EnvironmentalBoatTypes;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredItem;

public class EnvironmentalItems {
    public static final ItemSubRegistryHelper ITEMS = (ItemSubRegistryHelper)Environmental.REGISTRY_HELPER.getItemSubHelper();
    public static final DeferredItem<Item> CHERRIES = ITEMS.createItem("cherries", () -> new Item(new Item.Properties().food(EnvironmentalFoods.CHERRIES)));
    public static final DeferredItem<Item> PLUM = ITEMS.createItem("plum", () -> new Item(new Item.Properties().food(EnvironmentalFoods.PLUM)));
    public static final DeferredItem<Item> VENISON = ITEMS.createItem("venison", () -> new Item(new Item.Properties().food(EnvironmentalFoods.VENISON)));
    public static final DeferredItem<Item> COOKED_VENISON = ITEMS.createItem("cooked_venison", () -> new Item(new Item.Properties().food(EnvironmentalFoods.COOKED_VENISON)));
    public static final DeferredItem<Item> KOI = ITEMS.createItem("koi", () -> new Item(new Item.Properties().food(EnvironmentalFoods.KOI)));
    public static final DeferredItem<Item> DUCK = ITEMS.createItem("duck", () -> new Item(new Item.Properties().food(EnvironmentalFoods.DUCK)));
    public static final DeferredItem<Item> COOKED_DUCK = ITEMS.createItem("cooked_duck", () -> new Item(new Item.Properties().food(EnvironmentalFoods.COOKED_DUCK)));
    public static final DeferredItem<Item> DUCK_EGG = ITEMS.createItem("duck_egg", () -> new DuckEggItem(new Item.Properties().stacksTo(16)));
    public static final DeferredItem<Item> TRUFFLE = ITEMS.createItem("truffle", () -> new Item(new Item.Properties().food(EnvironmentalFoods.TRUFFLE)));
    public static final DeferredItem<Item> MUD_BALL = ITEMS.createItem("mud_ball", () -> new MudBallItem(new Item.Properties()));
    public static final DeferredItem<Item> YAK_HAIR = ITEMS.createItem("yak_hair", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> YAK_PANTS = ITEMS.createItem("yak_pants", () -> new YakPantsItem((Holder<ArmorMaterial>)EnvironmentalArmorMaterials.YAK, ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(5))));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> WILLOW_BOAT = ITEMS.createBoatAndChestBoatItem("willow", EnvironmentalBlocks.WILLOW_PLANKS);
    public static final DeferredItem<Item> WILLOW_FURNACE_BOAT = ITEMS.createItem("willow_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.WILLOW_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_WILLOW_BOAT = ITEMS.createItem("large_willow_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_WILLOW_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> PINE_BOAT = ITEMS.createBoatAndChestBoatItem("pine", EnvironmentalBlocks.PINE_PLANKS);
    public static final DeferredItem<Item> PINE_FURNACE_BOAT = ITEMS.createItem("pine_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.PINE_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_PINE_BOAT = ITEMS.createItem("large_pine_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_PINE_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> WISTERIA_BOAT = ITEMS.createBoatAndChestBoatItem("wisteria", EnvironmentalBlocks.WISTERIA_PLANKS);
    public static final DeferredItem<Item> WISTERIA_FURNACE_BOAT = ITEMS.createItem("wisteria_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.WISTERIA_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_WISTERIA_BOAT = ITEMS.createItem("large_wisteria_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_WISTERIA_BOAT : () -> new Item(new Item.Properties()));
    public static final Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> PLUM_BOAT = ITEMS.createBoatAndChestBoatItem("plum", EnvironmentalBlocks.PLUM_PLANKS);
    public static final DeferredItem<Item> PLUM_FURNACE_BOAT = ITEMS.createItem("plum_furnace_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.PLUM_FURNACE_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LARGE_PLUM_BOAT = ITEMS.createItem("large_plum_boat", ModList.get().isLoaded("boatload") ? EnvironmentalBoatTypes.LARGE_PLUM_BOAT : () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CATTAIL_FLUFF = ITEMS.createItem("cattail_fluff", () -> new ItemNameBlockItem((Block)EnvironmentalBlocks.CATTAIL_SPROUT.get(), new Item.Properties()));
    public static final DeferredItem<Item> DUCKWEED = ITEMS.createItem("duckweed", () -> new PlaceOnWaterBlockItem((Block)EnvironmentalBlocks.DUCKWEED.get(), new Item.Properties()));
    public static final DeferredItem<Item> MUSIC_DISC_LEAVING_HOME = ITEMS.createItem("music_disc_leaving_home", () -> new Item(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(EnvironmentalJukeboxSongs.LEAVING_HOME)));
    public static final DeferredItem<Item> MUSIC_DISC_SLABRAVE = ITEMS.createItem("music_disc_slabrave", () -> new Item(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).jukeboxPlayable(EnvironmentalJukeboxSongs.SLABRAVE)));
    public static final DeferredItem<Item> LUMBERER_BANNER_PATTERN = ITEMS.createItem("lumberer_banner_pattern", () -> new BannerPatternItem(EnvironmentalBannerPatternTags.PATTERN_ITEM_LUMBERER, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> HELPER_BANNER_PATTERN = ITEMS.createItem("helper_banner_pattern", () -> new BannerPatternItem(EnvironmentalBannerPatternTags.PATTERN_ITEM_HELPER, new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> SLABFISH_BUCKET = ITEMS.createItem("slabfish_bucket", () -> new SlabfishBucketItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> KOI_BUCKET = ITEMS.createItem("koi_bucket", () -> new KoiBucketItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> YELLOW_HIBISCUS = ITEMS.createItem("yellow_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.YELLOW_HIBISCUS.get(), (Block)EnvironmentalBlocks.YELLOW_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final DeferredItem<Item> ORANGE_HIBISCUS = ITEMS.createItem("orange_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.ORANGE_HIBISCUS.get(), (Block)EnvironmentalBlocks.ORANGE_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final DeferredItem<Item> RED_HIBISCUS = ITEMS.createItem("red_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.RED_HIBISCUS.get(), (Block)EnvironmentalBlocks.RED_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final DeferredItem<Item> PINK_HIBISCUS = ITEMS.createItem("pink_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.PINK_HIBISCUS.get(), (Block)EnvironmentalBlocks.PINK_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final DeferredItem<Item> MAGENTA_HIBISCUS = ITEMS.createItem("magenta_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.MAGENTA_HIBISCUS.get(), (Block)EnvironmentalBlocks.MAGENTA_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final DeferredItem<Item> PURPLE_HIBISCUS = ITEMS.createItem("purple_hibiscus", () -> new HibiscusBlockItem((Block)EnvironmentalBlocks.PURPLE_HIBISCUS.get(), (Block)EnvironmentalBlocks.PURPLE_WALL_HIBISCUS.get(), new Item.Properties()));
    public static final DeferredItem<DeferredSpawnEggItem> SLABFISH_SPAWN_EGG = ITEMS.createSpawnEggItem("slabfish", () -> EnvironmentalEntityTypes.SLABFISH.get(), 6263617, 13940616);
    public static final DeferredItem<DeferredSpawnEggItem> DUCK_SPAWN_EGG = ITEMS.createSpawnEggItem("duck", () -> EnvironmentalEntityTypes.DUCK.get(), 2775862, 15911223);
    public static final DeferredItem<DeferredSpawnEggItem> DEER_SPAWN_EGG = ITEMS.createSpawnEggItem("deer", () -> EnvironmentalEntityTypes.DEER.get(), 10582602, 15125414);
    public static final DeferredItem<DeferredSpawnEggItem> REINDEER_SPAWN_EGG = ITEMS.createSpawnEggItem("reindeer", () -> EnvironmentalEntityTypes.REINDEER.get(), 7360069, 15388873);
    public static final DeferredItem<DeferredSpawnEggItem> YAK_SPAWN_EGG = ITEMS.createSpawnEggItem("yak", () -> EnvironmentalEntityTypes.YAK.get(), 0x443934, 14263653);
    public static final DeferredItem<DeferredSpawnEggItem> KOI_SPAWN_EGG = ITEMS.createSpawnEggItem("koi", () -> EnvironmentalEntityTypes.KOI.get(), 3618365, 16749163);
    public static final DeferredItem<DeferredSpawnEggItem> TAPIR_SPAWN_EGG = ITEMS.createSpawnEggItem("tapir", () -> EnvironmentalEntityTypes.TAPIR.get(), 3684157, 13028046);
    public static final DeferredItem<DeferredSpawnEggItem> ZEBRA_SPAWN_EGG = ITEMS.createSpawnEggItem("zebra", () -> EnvironmentalEntityTypes.ZEBRA.get(), 13945798, 3419691);
    public static final DeferredItem<DeferredSpawnEggItem> ZORSE_SPAWN_EGG = ITEMS.createSpawnEggItem("zorse", () -> EnvironmentalEntityTypes.ZORSE.get(), 12623485, 3419691);
    public static final DeferredItem<DeferredSpawnEggItem> ZONKEY_SPAWN_EGG = ITEMS.createSpawnEggItem("zonkey", () -> EnvironmentalEntityTypes.ZONKEY.get(), 5457209, 3419691);
    public static final DeferredItem<DeferredSpawnEggItem> PINECONE_GOLEM_SPAWN_EGG = ITEMS.createSpawnEggItem("pinecone_golem", () -> EnvironmentalEntityTypes.PINECONE_GOLEM.get(), 7822665, 9412935);

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"environmental").tab(CreativeModeTabs.FOOD_AND_DRINKS).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), new Supplier[]{CHERRIES, PLUM}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN}), new Supplier[]{VENISON, COOKED_VENISON}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT}), new Supplier[]{DUCK, COOKED_DUCK}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), new Supplier[]{TRUFFLE}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH}), new Supplier[]{KOI}).tab(CreativeModeTabs.INGREDIENTS).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOBE_BANNER_PATTERN}), new Supplier[]{LUMBERER_BANNER_PATTERN, HELPER_BANNER_PATTERN}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG}), new Supplier[]{DUCK_EGG}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}), new Supplier[]{YAK_HAIR}).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY_BALL}), new Supplier[]{MUD_BALL}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}), new Supplier[]{CATTAIL_FLUFF}).tab(CreativeModeTabs.COMBAT).addItemsAfter((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG}), new Supplier[]{MUD_BALL}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_HORSE_ARMOR}), new Supplier[]{YAK_PANTS}).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH_BUCKET}), new Supplier[]{KOI_BUCKET}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TADPOLE_BUCKET}), new Supplier[]{SLABFISH_BUCKET}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{(Supplier)WILLOW_BOAT.getFirst(), (Supplier)WILLOW_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{WILLOW_FURNACE_BOAT, LARGE_WILLOW_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{(Supplier)PINE_BOAT.getFirst(), (Supplier)PINE_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{PINE_FURNACE_BOAT, LARGE_PINE_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{(Supplier)PLUM_BOAT.getFirst(), (Supplier)PLUM_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{PLUM_FURNACE_BOAT, LARGE_PLUM_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_RAFT}), new Supplier[]{(Supplier)WISTERIA_BOAT.getFirst(), (Supplier)WISTERIA_BOAT.getSecond()}).addItemsBefore(EnvironmentalItems.modLoaded((ItemLike)Items.BAMBOO_RAFT, "boatload"), new Supplier[]{WISTERIA_FURNACE_BOAT, LARGE_WISTERIA_BOAT}).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.MUSIC_DISC_5}), new Supplier[]{MUSIC_DISC_LEAVING_HOME, MUSIC_DISC_SLABRAVE}).tab(CreativeModeTabs.NATURAL_BLOCKS).addItemsBefore((Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCHFLOWER_SEEDS}), new Supplier[]{CATTAIL_FLUFF}).tab(CreativeModeTabs.SPAWN_EGGS).addItemsAlphabetically(ItemStackUtil.is(SpawnEggItem.class), "spawn_egg|_", new Supplier[]{SLABFISH_SPAWN_EGG, DUCK_SPAWN_EGG, DEER_SPAWN_EGG, REINDEER_SPAWN_EGG, YAK_SPAWN_EGG, KOI_SPAWN_EGG, TAPIR_SPAWN_EGG, ZEBRA_SPAWN_EGG, ZORSE_SPAWN_EGG, ZONKEY_SPAWN_EGG, PINECONE_GOLEM_SPAWN_EGG});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.of((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static final class EnvironmentalFoods {
        public static final FoodProperties CHERRIES = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().build();
        public static final FoodProperties PLUM = new FoodProperties.Builder().nutrition(5).saturationModifier(0.3f).build();
        public static final FoodProperties VENISON = new FoodProperties.Builder().nutrition(2).saturationModifier(0.3f).build();
        public static final FoodProperties COOKED_VENISON = new FoodProperties.Builder().nutrition(6).saturationModifier(0.8f).build();
        public static final FoodProperties DUCK = new FoodProperties.Builder().nutrition(4).saturationModifier(0.1f).effect(() -> new MobEffectInstance(MobEffects.HUNGER, 600, 0), 0.3f).build();
        public static final FoodProperties COOKED_DUCK = new FoodProperties.Builder().nutrition(8).saturationModifier(0.3f).build();
        public static final FoodProperties TRUFFLE = new FoodProperties.Builder().nutrition(16).saturationModifier(1.2f).build();
        public static final FoodProperties KOI = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).build();
    }
}

