/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.teamabnormals.environmental.core.Environmental;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class EnvironmentalDamageTypes {
    public static final ResourceKey<DamageType> RIDING_ZEBRA = EnvironmentalDamageTypes.create("riding_zebra");

    public static void bootstrap(BootstrapContext<DamageType> context) {
        EnvironmentalDamageTypes.register(context, RIDING_ZEBRA, "ridingZebra", 0.1f);
    }

    public static DamageSource ridingZebra(Level level, Entity mount, @Nullable Entity rider) {
        return level.damageSources().source(RIDING_ZEBRA, mount, rider);
    }

    public static Holder.Reference<DamageType> register(BootstrapContext<DamageType> context, ResourceKey<DamageType> key, String localizationKey, float exhaustion) {
        return context.register(key, (Object)new DamageType("environmental." + localizationKey, exhaustion));
    }

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Environmental.location(name));
    }
}

