/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.teamabnormals.environmental.common.entity.animal.deer.DeerVariant;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class EnvironmentalDeerVariants {
    public static final ResourceKey<DeerVariant> CREAMY = EnvironmentalDeerVariants.create("creamy");
    public static final ResourceKey<DeerVariant> CHESTNUT = EnvironmentalDeerVariants.create("chestnut");
    public static final ResourceKey<DeerVariant> GRAY = EnvironmentalDeerVariants.create("gray");
    public static final ResourceKey<DeerVariant> DEFAULT = CREAMY;

    public static void bootstrap(BootstrapContext<DeerVariant> context) {
        EnvironmentalDeerVariants.register(context, CREAMY, (TagKey<Biome>)BiomeTags.IS_FOREST, 0);
        EnvironmentalDeerVariants.register(context, CHESTNUT, EnvironmentalBiomeTags.SPAWNS_CHESTNUT_DEER, 1);
        EnvironmentalDeerVariants.register(context, GRAY, EnvironmentalBiomeTags.SPAWNS_GRAY_DEER, 1);
    }

    public static void register(BootstrapContext<DeerVariant> context, ResourceKey<DeerVariant> key, ResourceKey<Biome> spawnBiome, int priority) {
        EnvironmentalDeerVariants.register(context, key, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(spawnBiome)}), priority);
    }

    public static void register(BootstrapContext<DeerVariant> context, ResourceKey<DeerVariant> key, TagKey<Biome> spawnBiomes, int priority) {
        EnvironmentalDeerVariants.register(context, key, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(spawnBiomes), priority);
    }

    public static void register(BootstrapContext<DeerVariant> context, ResourceKey<DeerVariant> key, HolderSet<Biome> spawnBiomes, int priority) {
        context.register(key, (Object)new DeerVariant(key.location().withPrefix("entity/deer/deer_"), spawnBiomes, priority));
    }

    public static ResourceKey<DeerVariant> create(String name) {
        return ResourceKey.create(EnvironmentalRegistries.DEER_VARIANT, (ResourceLocation)Environmental.location(name));
    }
}

