/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry.datapack;

import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.registry.datapack.EnvironmentalBiomes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.Biome;

public class EnvironmentalWolfVariants {
    public static final ResourceKey<WolfVariant> OMBRE = EnvironmentalWolfVariants.create("ombre");
    public static final ResourceKey<WolfVariant> TAWNY = EnvironmentalWolfVariants.create("tawny");
    public static final ResourceKey<WolfVariant> HORIZON = EnvironmentalWolfVariants.create("horizon");
    public static final ResourceKey<WolfVariant> GRAY = EnvironmentalWolfVariants.create("gray");
    public static final ResourceKey<WolfVariant> TIMBER = EnvironmentalWolfVariants.create("timber");

    public static void bootstrap(BootstrapContext<WolfVariant> context) {
        EnvironmentalWolfVariants.register(context, OMBRE, "wolf_ombre", EnvironmentalBiomes.PINE_SLOPES);
        EnvironmentalWolfVariants.register(context, TAWNY, "wolf_tawny", EnvironmentalBiomes.PINE_BARRENS);
        EnvironmentalWolfVariants.register(context, HORIZON, "wolf_horizon", EnvironmentalBiomes.SNOWY_PINE_BARRENS);
        EnvironmentalWolfVariants.register(context, GRAY, "wolf_gray", EnvironmentalBiomes.OLD_GROWTH_PINE_BARRENS);
        EnvironmentalWolfVariants.register(context, TIMBER, "wolf_timber", EnvironmentalBiomes.SNOWY_OLD_GROWTH_PINE_BARRENS);
    }

    private static ResourceKey<WolfVariant> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.WOLF_VARIANT, (ResourceLocation)Environmental.location(name));
    }

    static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, ResourceKey<Biome> spawnBiome) {
        EnvironmentalWolfVariants.register(context, key, name, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(spawnBiome)}));
    }

    private static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, TagKey<Biome> spawnBiomes) {
        EnvironmentalWolfVariants.register(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(spawnBiomes));
    }

    private static void register(BootstrapContext<WolfVariant> context, ResourceKey<WolfVariant> key, String name, HolderSet<Biome> spawnBiomes) {
        ResourceLocation texture = Environmental.location("entity/wolf/" + name);
        ResourceLocation tame = Environmental.location("entity/wolf/" + name + "_tame");
        ResourceLocation angry = Environmental.location("entity/wolf/" + name + "_angry");
        context.register(key, (Object)new WolfVariant(texture, tame, angry, spawnBiomes));
    }
}

